/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.simple.cookies;

import io.micronaut.core.util.ObjectUtils;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.SameSite;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

public class SimpleCookie
implements Cookie {
    private final String name;
    private String value;
    private String domain;
    private String path;
    private boolean httpOnly;
    private boolean secure;
    private long maxAge;
    private SameSite sameSite;

    public SimpleCookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull String getValue() {
        return this.value;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public long getMaxAge() {
        return this.maxAge;
    }

    @Override
    public Optional<SameSite> getSameSite() {
        return Optional.ofNullable(this.sameSite);
    }

    @Override
    public @NonNull Cookie sameSite(SameSite sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    @Override
    public @NonNull Cookie maxAge(long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @Override
    public @NonNull Cookie value(@NonNull String value) {
        this.value = value;
        return this;
    }

    @Override
    public @NonNull Cookie domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public @NonNull Cookie path(String path) {
        this.path = path;
        return this;
    }

    @Override
    public @NonNull Cookie secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    @Override
    public @NonNull Cookie httpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cookie)) {
            return false;
        }
        Cookie that = (Cookie)o;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (this.getPath() == null) {
            if (that.getPath() != null) {
                return false;
            }
        } else {
            if (that.getPath() == null) {
                return false;
            }
            if (!this.getPath().equals(that.getPath())) {
                return false;
            }
        }
        if (this.getDomain() == null) {
            return that.getDomain() == null;
        }
        return this.getDomain().equalsIgnoreCase(that.getDomain());
    }

    @Override
    public int compareTo(Cookie c) {
        int v = this.getName().compareTo(c.getName());
        if (v != 0) {
            return v;
        }
        if (this.getPath() == null) {
            if (c.getPath() != null) {
                return -1;
            }
        } else {
            if (c.getPath() == null) {
                return 1;
            }
            v = this.getPath().compareTo(c.getPath());
            if (v != 0) {
                return v;
            }
        }
        if (this.getDomain() == null) {
            if (c.getDomain() != null) {
                return -1;
            }
        } else {
            if (c.getDomain() == null) {
                return 1;
            }
            v = this.getDomain().compareToIgnoreCase(c.getDomain());
            return v;
        }
        return 0;
    }

    public int hashCode() {
        return ObjectUtils.hash((Object)this.name, (Object)this.domain, (Object)this.path);
    }

    public String toString() {
        Optional<SameSite> ss;
        StringBuilder buf = new StringBuilder().append(this.getName()).append('=').append(this.getValue());
        if (this.getDomain() != null) {
            buf.append(", domain=").append(this.getDomain());
        }
        if (this.getPath() != null) {
            buf.append(", path=").append(this.getPath());
        }
        if (this.getMaxAge() >= 0L) {
            buf.append(", maxAge=").append(this.getMaxAge()).append('s');
        }
        if (this.isSecure()) {
            buf.append(", secure");
        }
        if (this.isHttpOnly()) {
            buf.append(", HTTPOnly");
        }
        if ((ss = this.getSameSite()).isPresent()) {
            buf.append(", SameSite=").append((Object)ss.get());
        }
        return buf.toString();
    }
}

