/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.resource;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.file.DefaultFileSystemResourceLoader;
import io.micronaut.core.io.file.FileSystemResourceLoader;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.io.scan.DefaultClassPathResourceLoader;
import io.micronaut.core.io.value.Base64ResourceLoader;
import io.micronaut.core.io.value.StringResourceLoader;
import jakarta.inject.Singleton;
import java.util.List;
import org.jspecify.annotations.NonNull;

@Factory
@BootstrapContextCompatible
public class ResourceLoaderFactory {
    private final ClassLoader classLoader;

    public ResourceLoaderFactory(Environment environment) {
        this.classLoader = environment.getClassLoader();
    }

    @Singleton
    @BootstrapContextCompatible
    protected @NonNull ClassPathResourceLoader getClassPathResourceLoader() {
        return new DefaultClassPathResourceLoader(this.classLoader);
    }

    @Singleton
    @BootstrapContextCompatible
    protected @NonNull FileSystemResourceLoader fileSystemResourceLoader() {
        return new DefaultFileSystemResourceLoader();
    }

    @Singleton
    @BootstrapContextCompatible
    protected @NonNull ResourceLoader getStringResourceLoader() {
        return StringResourceLoader.getInstance();
    }

    @Singleton
    @BootstrapContextCompatible
    protected @NonNull ResourceLoader getBase64ResourceLoader() {
        return Base64ResourceLoader.getInstance();
    }

    @Singleton
    @BootstrapContextCompatible
    @Indexed(value=ResourceResolver.class)
    protected @NonNull ResourceResolver resourceResolver(@NonNull List<ResourceLoader> resourceLoaders) {
        return new ResourceResolver(resourceLoaders);
    }
}

