/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.reactive.execution;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.http.reactive.execution.ReactorExecutionFlowImpl;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.jspecify.annotations.NonNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Internal
public sealed interface ReactiveExecutionFlow<T>
extends ExecutionFlow<T>
permits ReactorExecutionFlowImpl {
    public static <K> @NonNull ReactiveExecutionFlow<K> fromPublisher(@NonNull Publisher<K> publisher) {
        return new ReactorExecutionFlowImpl(publisher);
    }

    public static <K> @NonNull ExecutionFlow<K> fromPublisherEager(@NonNull Publisher<K> publisher, @NonNull PropagatedContext propagatedContext) {
        return ReactorExecutionFlowImpl.defuse(publisher, propagatedContext);
    }

    public static <K> @NonNull ReactiveExecutionFlow<K> async(@NonNull Executor executor, @NonNull Supplier<ExecutionFlow<K>> supplier) {
        Scheduler scheduler = Schedulers.fromExecutor((Executor)executor);
        return new ReactorExecutionFlowImpl(Mono.fromSupplier(supplier).flatMap(ReactorExecutionFlowImpl::toMono).subscribeOn(scheduler));
    }

    public static <K> @NonNull ReactiveExecutionFlow<K> fromFlow(@NonNull ExecutionFlow<K> flow) {
        if (flow instanceof ReactiveExecutionFlow) {
            ReactiveExecutionFlow executionFlow = (ReactiveExecutionFlow)flow;
            return executionFlow;
        }
        return new ReactorExecutionFlowImpl(ReactorExecutionFlowImpl.toMono(flow));
    }

    public @NonNull Publisher<T> toPublisher();

    @SingleResult
    public static <K> @NonNull Publisher<K> toPublisher(@NonNull Supplier<@NonNull ExecutionFlow<K>> flowSupplier) {
        return ReactorExecutionFlowImpl.toMono(flowSupplier);
    }

    @SingleResult
    public static <K> @NonNull Publisher<K> toPublisher(@NonNull ExecutionFlow<K> flow) {
        return ReactorExecutionFlowImpl.toMono(flow);
    }
}

