/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.hateoas;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.http.hateoas.AbstractResource;
import java.util.LinkedHashMap;
import java.util.Map;

@Introspected
@ReflectiveAccess
public final class GenericResource
extends AbstractResource<GenericResource> {
    private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    @Internal
    public GenericResource() {
    }

    @Internal
    @JsonAnySetter
    public void addProperty(String key, Object v) {
        this.additionalProperties.put(key, v);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof GenericResource)) return false;
        GenericResource gr = (GenericResource)o;
        if (!this.getLinks().equals(gr.getLinks())) return false;
        if (!this.getEmbedded().equals(gr.getEmbedded())) return false;
        if (!this.getAdditionalProperties().equals(gr.getAdditionalProperties())) return false;
        return true;
    }

    public int hashCode() {
        return ObjectUtils.hash(this.getLinks(), this.getEmbedded(), this.getAdditionalProperties());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("GenericResource{").append("_links=").append(this.getLinks()).append(", _embedded=").append(this.getEmbedded());
        this.additionalProperties.forEach((k, v) -> sb.append(", ").append((String)k).append('=').append(v));
        return sb.append('}').toString();
    }
}

