/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.order.Ordered;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.filter.AroundLegacyFilter;
import io.micronaut.http.filter.FilterContext;
import io.micronaut.http.filter.FilterRunner;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.MethodFilter;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
sealed interface InternalHttpFilter
extends GenericHttpFilter,
Ordered
permits AroundLegacyFilter, FilterRunner.RouteMatchResolverHttpFilter, MethodFilter {
    default public boolean isEnabled(HttpRequest<?> request) {
        return true;
    }

    default public boolean isFiltersRequest() {
        return false;
    }

    default public boolean isFiltersResponse() {
        return false;
    }

    default public boolean hasContinuation() {
        return false;
    }

    default public @NonNull ExecutionFlow<FilterContext> processRequestFilter(@NonNull FilterContext context) {
        if (!this.isFiltersRequest()) {
            throw new IllegalStateException("Filtering request is not supported!");
        }
        return ExecutionFlow.just((Object)context);
    }

    default public @NonNull ExecutionFlow<FilterContext> processRequestFilter(@NonNull FilterContext context, @NonNull Function<FilterContext, ExecutionFlow<FilterContext>> downstream) {
        if (!this.isFiltersRequest()) {
            throw new IllegalStateException("Filtering request is not supported!");
        }
        return downstream.apply(context);
    }

    default public @NonNull ExecutionFlow<FilterContext> processResponseFilter(@NonNull FilterContext context, @Nullable Throwable exceptionToFilter) {
        if (!this.isFiltersResponse()) {
            throw new IllegalStateException("Filtering response is not supported!");
        }
        return ExecutionFlow.just((Object)context);
    }
}

