/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.filter;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.filter.DefaultFilterEntry;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.HttpFilter;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface HttpFilterResolver<T extends AnnotationMetadataProvider> {
    public List<FilterEntry> resolveFilterEntries(T var1);

    public List<GenericHttpFilter> resolveFilters(HttpRequest<?> var1, List<FilterEntry> var2);

    public static interface FilterEntry
    extends AnnotationMetadataProvider {
        public @NonNull GenericHttpFilter getFilter();

        public @NonNull Set<HttpMethod> getFilterMethods();

        public @NonNull String[] getPatterns();

        default public FilterPatternStyle getPatternStyle() {
            return FilterPatternStyle.defaultStyle();
        }

        default public boolean hasMethods() {
            return CollectionUtils.isNotEmpty(this.getFilterMethods());
        }

        default public boolean hasPatterns() {
            return ArrayUtils.isNotEmpty((Object[])this.getPatterns());
        }

        public static FilterEntry of(@NonNull HttpFilter filter, @Nullable AnnotationMetadata annotationMetadata, @Nullable Set<HttpMethod> methods, @NonNull FilterPatternStyle patternStyle, String ... patterns) {
            return new DefaultFilterEntry(GenericHttpFilter.createLegacyFilter(Objects.requireNonNull(filter, "Filter cannot be null"), new FilterOrder.Dynamic(OrderUtil.getOrder((AnnotationMetadata)annotationMetadata))), annotationMetadata != null ? annotationMetadata : AnnotationMetadata.EMPTY_METADATA, methods, patternStyle, patterns);
        }
    }
}

