/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.cookie;

import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.http.cookie.CookieFactory;
import io.micronaut.http.cookie.SameSite;
import java.io.Serializable;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface Cookie
extends Comparable<Cookie>,
Serializable {
    public static final long UNDEFINED_MAX_AGE = Long.MIN_VALUE;
    public static final String ATTRIBUTE_SECURE = "Secure";
    public static final String ATTRIBUTE_HTTP_ONLY = "HttpOnly";
    public static final String ATTRIBUTE_SAME_SITE = "SameSite";
    public static final String ATTRIBUTE_DOMAIN = "Domain";
    public static final String ATTRIBUTE_PATH = "Path";
    public static final String ATTRIBUTE_EXPIRES = "Expires";
    public static final String ATTRIBUTE_MAX_AGE = "Max-Age";

    public @NonNull String getName();

    public @NonNull String getValue();

    public @Nullable String getDomain();

    public @Nullable String getPath();

    public boolean isHttpOnly();

    public boolean isSecure();

    public long getMaxAge();

    default public Optional<SameSite> getSameSite() {
        return Optional.empty();
    }

    default public @NonNull Cookie sameSite(@Nullable SameSite sameSite) {
        return this;
    }

    public @NonNull Cookie maxAge(long var1);

    public @NonNull Cookie value(@NonNull String var1);

    public @NonNull Cookie domain(@Nullable String var1);

    public @NonNull Cookie path(@Nullable String var1);

    public @NonNull Cookie secure(boolean var1);

    default public @NonNull Cookie secure() {
        return this.secure(true);
    }

    public @NonNull Cookie httpOnly(boolean var1);

    default public @NonNull Cookie httpOnly() {
        return this.httpOnly(true);
    }

    default public @NonNull Cookie configure(@NonNull CookieConfiguration configuration) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        return this.configure(configuration, true);
    }

    default public @NonNull Cookie configure(@NonNull CookieConfiguration configuration, boolean isSecure) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        configuration.getCookiePath().ifPresent(this::path);
        configuration.getCookieDomain().ifPresent(this::domain);
        configuration.getCookieMaxAge().ifPresent(this::maxAge);
        configuration.isCookieHttpOnly().ifPresent(this::httpOnly);
        Optional<Boolean> secureConfiguration = configuration.isCookieSecure();
        if (secureConfiguration.isPresent()) {
            this.secure(secureConfiguration.get());
        } else {
            this.secure(isSecure);
        }
        configuration.getCookieSameSite().ifPresent(this::sameSite);
        return this;
    }

    default public @NonNull Cookie maxAge(@NonNull TemporalAmount maxAge) {
        ArgumentUtils.requireNonNull((String)"maxAge", (Object)maxAge);
        return this.maxAge(maxAge.get(ChronoUnit.SECONDS));
    }

    public static @NonNull Cookie of(@NonNull String name, @NonNull String value) {
        CookieFactory instance = CookieFactory.INSTANCE;
        if (instance != null) {
            return instance.create(name, value);
        }
        throw new UnsupportedOperationException("No CookeFactory implementation found. Server implementation does not support cookies.");
    }
}

