/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.context;

import io.micronaut.core.util.StringUtils;
import io.micronaut.http.context.ClientContextPathProvider;
import io.micronaut.http.context.ServerContextPathProvider;
import java.net.URI;
import java.net.URISyntaxException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ContextPathUtils {
    private ContextPathUtils() {
    }

    public static @NonNull URI prepend(@NonNull URI requestURI, @Nullable ServerContextPathProvider serverContextPathProvider) throws URISyntaxException {
        return ContextPathUtils.prepend(requestURI, serverContextPathProvider.getContextPath());
    }

    public static @NonNull URI prepend(@NonNull URI requestURI, @Nullable ClientContextPathProvider clientContextPathProvider) throws URISyntaxException {
        return ContextPathUtils.prepend(requestURI, clientContextPathProvider.getContextPath().orElse(null));
    }

    public static @NonNull URI prepend(@NonNull URI requestURI, @Nullable String contextPath) throws URISyntaxException {
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            return new URI(StringUtils.prependUri((String)contextPath, (String)requestURI.toString()));
        }
        return requestURI;
    }
}

