/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.codec;

import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

@Deprecated(forRemoval=true, since="4.7")
public class DefaultMediaTypeCodecRegistry
implements MediaTypeCodecRegistry {
    Map<String, Optional<MediaTypeCodec>> decodersByExtension = new LinkedHashMap<String, Optional<MediaTypeCodec>>(3);
    Map<MediaType, Optional<MediaTypeCodec>> decodersByType = new LinkedHashMap<MediaType, Optional<MediaTypeCodec>>(3);
    private final Collection<MediaTypeCodec> codecs;

    DefaultMediaTypeCodecRegistry(MediaTypeCodec ... codecs) {
        this(Arrays.asList(codecs));
    }

    DefaultMediaTypeCodecRegistry(Collection<MediaTypeCodec> codecs) {
        if (codecs != null) {
            this.codecs = Collections.unmodifiableCollection(codecs);
            for (MediaTypeCodec decoder : codecs) {
                Collection<MediaType> mediaTypes = decoder.getMediaTypes();
                for (MediaType mediaType : mediaTypes) {
                    if (mediaType == null) continue;
                    this.decodersByExtension.put(mediaType.getExtension(), Optional.of(decoder));
                    this.decodersByType.put(mediaType, Optional.of(decoder));
                }
            }
        } else {
            this.codecs = Collections.emptyList();
        }
    }

    @Override
    public Optional<MediaTypeCodec> findCodec(@Nullable MediaType mediaType) {
        if (mediaType == null) {
            return Optional.empty();
        }
        Optional<MediaTypeCodec> decoder = this.decodersByType.get(mediaType);
        if (decoder == null) {
            decoder = this.decodersByExtension.get(mediaType.getExtension());
        }
        return decoder == null ? Optional.empty() : decoder;
    }

    @Override
    public Optional<MediaTypeCodec> findCodec(@Nullable MediaType mediaType, Class<?> type) {
        Optional<MediaTypeCodec> codec = this.findCodec(mediaType);
        if (codec.isPresent()) {
            MediaTypeCodec mediaTypeCodec = codec.get();
            if (mediaTypeCodec.supportsType(type)) {
                return codec;
            }
            return Optional.empty();
        }
        return codec;
    }

    @Override
    public Collection<MediaTypeCodec> getCodecs() {
        return this.codecs;
    }
}

