/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.cachecontrol;

import io.micronaut.http.cachecontrol.ResponseDirective;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public record CacheControl(@NonNull List<CacheControlResponseDirective> responseDirectives) {
    private static final String EQUAL = "=";

    @Override
    public String toString() {
        return String.join((CharSequence)", ", this.responseDirectives.stream().map(dir -> dir.seconds() != null ? String.join((CharSequence)EQUAL, dir.directive().toString(), String.valueOf(dir.seconds())) : dir.directive().toString()).toList());
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<CacheControlResponseDirective> responseDirectives = new ArrayList<CacheControlResponseDirective>();

        private Builder() {
        }

        public @NonNull Builder proxyRevalidate() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.PROXY_REVALIDATE));
            return this;
        }

        public @NonNull Builder mustRevalidate() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.MUST_REVALIDATE));
            return this;
        }

        public @NonNull Builder sMaxAge(@NonNull Long sMaxAge) {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.S_MAXAGE, sMaxAge));
            return this;
        }

        public @NonNull Builder sMaxAge(@NonNull Duration sMaxAge) {
            return this.sMaxAge(sMaxAge.getSeconds());
        }

        public @NonNull Builder maxAge(@NonNull Long maxAge) {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.MAX_AGE, maxAge));
            return this;
        }

        public @NonNull Builder maxAge(@NonNull Duration maxAge) {
            return this.maxAge(maxAge.getSeconds());
        }

        public @NonNull Builder inmutable() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.IMMUTABLE));
            return this;
        }

        public @NonNull Builder publicDirective() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.PUBLIC));
            return this;
        }

        public @NonNull Builder privateDirective() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.PRIVATE));
            return this;
        }

        public @NonNull Builder noStore() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.NO_STORE));
            return this;
        }

        public @NonNull Builder noCache() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.NO_CACHE));
            return this;
        }

        public @NonNull Builder mustUnderstand() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.MUST_UNDERSTAND));
            return this;
        }

        public @NonNull Builder noTransform() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.NO_TRANSFORM));
            return this;
        }

        public @NonNull Builder staleWhileRevalidate(@NonNull Duration staleWhileRevalidate) {
            return this.staleWhileRevalidate(staleWhileRevalidate.getSeconds());
        }

        public @NonNull Builder staleWhileRevalidate(@NonNull Long seconds) {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.STALE_WHILE_REVALIDATE, seconds));
            return this;
        }

        public @NonNull Builder staleIfError(@NonNull Duration staleIfError) {
            return this.staleIfError(staleIfError.getSeconds());
        }

        public @NonNull Builder staleIfError(@NonNull Long seconds) {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.STALE_IF_ERROR, seconds));
            return this;
        }

        public @NonNull CacheControl build() {
            return new CacheControl(this.responseDirectives);
        }
    }

    record CacheControlResponseDirective(@NonNull ResponseDirective directive, @Nullable Long seconds) {
        CacheControlResponseDirective(@NonNull ResponseDirective directive) {
            this(directive, null);
        }
    }
}

