/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.stream.ByteQueue;
import io.micronaut.http.body.stream.ExtendedInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@Internal
final class StreamPair {
    private static final int FLAG_DISCARD_L = 1;
    private static final int FLAG_DISCARD_R = 2;
    private static final int MASK_DISCARD = 3;
    private static final int FLAG_CANCEL_L = 4;
    private static final int FLAG_CANCEL_R = 8;
    private static final int MASK_CANCEL = 12;
    private final Lock lock = new ReentrantLock();
    private final Condition wakeup = this.lock.newCondition();
    private final AtomicInteger flags = new AtomicInteger();
    private final ExtendedInputStream upstream;
    private Slowest.SlowestDemand slowestDemand = null;
    private ByteQueue queue;
    private boolean fastModeSlowerSide;
    private boolean singleSideComplete;
    private IOException singleSideException;

    private StreamPair(ExtendedInputStream upstream) {
        this.upstream = upstream;
    }

    private int getAndSetFlag(int flag) {
        return this.flags.getAndUpdate(f -> f | flag);
    }

    private boolean setFlagAndCheckMask(int flag, int mask) {
        int old = this.getAndSetFlag(flag);
        return (old & mask) != mask && ((old | flag) & mask) == mask;
    }

    static Pair createStreamPair(ExtendedInputStream upstream, ByteBody.SplitBackpressureMode backpressureMode) {
        StreamPair pair = new StreamPair(upstream);
        return switch (backpressureMode) {
            default -> throw new MatchException(null, null);
            case ByteBody.SplitBackpressureMode.SLOWEST -> {
                StreamPair v0 = pair;
                Objects.requireNonNull(v0);
                Slowest v1 = v0.new Slowest(true);
                StreamPair v2 = pair;
                Objects.requireNonNull(v2);
                yield new Pair(v1, v2.new Slowest(false));
            }
            case ByteBody.SplitBackpressureMode.FASTEST -> {
                pair.queue = new ByteQueue();
                StreamPair v4 = pair;
                Objects.requireNonNull(v4);
                Fastest v5 = v4.new Fastest(true);
                StreamPair v6 = pair;
                Objects.requireNonNull(v6);
                yield new Pair(v5, v6.new Fastest(false));
            }
            case ByteBody.SplitBackpressureMode.ORIGINAL -> {
                pair.queue = new ByteQueue();
                yield new Pair(pair.new Preferred(), pair.new Listening());
            }
            case ByteBody.SplitBackpressureMode.NEW -> {
                pair.queue = new ByteQueue();
                yield new Pair(pair.new Listening(), pair.new Preferred());
            }
        };
    }

    private final class Slowest
    extends Side {
        private Slowest(boolean left) {
            super(left);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            block15: {
                StreamPair.this.lock.lock();
                try {
                    SlowestDemand theirDemand = StreamPair.this.slowestDemand;
                    if (theirDemand == null) {
                        SlowestDemand ourDemand;
                        StreamPair.this.slowestDemand = ourDemand = new SlowestDemand(b, off, len);
                        do {
                            if (this.isOtherSideCancelled()) {
                                StreamPair.this.slowestDemand = null;
                                break block15;
                            }
                            try {
                                StreamPair.this.wakeup.await();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                if (ourDemand.fulfilled) continue;
                                StreamPair.this.slowestDemand = null;
                                throw new InterruptedIOException();
                            }
                        } while (!ourDemand.fulfilled);
                        if (ourDemand.exception != null) {
                            throw ourDemand.exception;
                        }
                        int e = ourDemand.actualLength;
                        return e;
                    }
                    int n = Math.min(len, theirDemand.len);
                    try {
                        int actualLength = StreamPair.this.upstream.read(b, off, n);
                        if (actualLength >= 0) {
                            System.arraycopy(b, off, theirDemand.dest, theirDemand.off, actualLength);
                        }
                        theirDemand.actualLength = actualLength;
                        theirDemand.fulfilled = true;
                        StreamPair.this.slowestDemand = null;
                        StreamPair.this.wakeup.signalAll();
                        int n2 = actualLength;
                        return n2;
                    }
                    catch (IOException e) {
                        theirDemand.exception = e;
                        theirDemand.fulfilled = true;
                        StreamPair.this.slowestDemand = null;
                        StreamPair.this.wakeup.signalAll();
                        throw e;
                    }
                }
                finally {
                    StreamPair.this.lock.unlock();
                }
            }
            return StreamPair.this.upstream.read(b, off, len);
        }

        @Override
        public void cancelInput() {
            super.cancelInput();
            StreamPair.this.lock.lock();
            try {
                StreamPair.this.wakeup.signalAll();
            }
            finally {
                StreamPair.this.lock.unlock();
            }
        }

        static class SlowestDemand {
            final byte[] dest;
            final int off;
            final int len;
            boolean fulfilled;
            IOException exception;
            int actualLength;

            SlowestDemand(byte[] dest, int off, int len) {
                this.dest = dest;
                this.off = off;
                this.len = len;
            }
        }
    }

    record Pair(ExtendedInputStream left, ExtendedInputStream right) {
    }

    private final class Fastest
    extends Side {
        private Fastest(boolean left) {
            super(left);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            StreamPair.this.lock.lock();
            try {
                if (!StreamPair.this.queue.isEmpty() && StreamPair.this.fastModeSlowerSide == this.left) {
                    int n = StreamPair.this.queue.take(b, off, len);
                    return n;
                }
                int n = StreamPair.this.upstream.read(b, off, len);
                if (n == -1) {
                    int n2 = -1;
                    return n2;
                }
                if (!this.isOtherSideCancelled()) {
                    StreamPair.this.fastModeSlowerSide = !this.left;
                    StreamPair.this.queue.addCopy(b, off, n);
                } else {
                    StreamPair.this.queue.clear();
                }
                int n3 = n;
                return n3;
            }
            finally {
                StreamPair.this.lock.unlock();
            }
        }
    }

    private final class Preferred
    extends Side {
        Preferred() {
            super(true);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            StreamPair.this.lock.lock();
            try {
                int n = StreamPair.this.upstream.read(b, off, len);
                if (n == -1) {
                    StreamPair.this.singleSideComplete = true;
                } else if (!this.isOtherSideCancelled()) {
                    StreamPair.this.queue.addCopy(b, off, n);
                } else {
                    StreamPair.this.queue.clear();
                }
                StreamPair.this.wakeup.signalAll();
                int n2 = n;
                return n2;
            }
            catch (IOException e) {
                StreamPair.this.singleSideException = e;
                StreamPair.this.wakeup.signalAll();
                throw e;
            }
            finally {
                StreamPair.this.lock.unlock();
            }
        }

        @Override
        public void cancelInput() {
            super.cancelInput();
            StreamPair.this.lock.lock();
            try {
                StreamPair.this.wakeup.signalAll();
            }
            finally {
                StreamPair.this.lock.unlock();
            }
        }
    }

    private final class Listening
    extends Side {
        Listening() {
            super(false);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            StreamPair.this.lock.lock();
            try {
                while (true) {
                    if (!StreamPair.this.queue.isEmpty()) {
                        int n = StreamPair.this.queue.take(b, off, len);
                        return n;
                    }
                    if (StreamPair.this.singleSideException != null) {
                        throw StreamPair.this.singleSideException;
                    }
                    if (StreamPair.this.singleSideComplete) {
                        int n = -1;
                        return n;
                    }
                    if (this.isOtherSideCancelled()) {
                        break;
                    }
                    StreamPair.this.wakeup.await();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
            finally {
                StreamPair.this.lock.unlock();
            }
            return StreamPair.this.upstream.read(b, off, len);
        }
    }

    private abstract class Side
    extends ExtendedInputStream {
        final boolean left;

        private Side(boolean left) {
            this.left = left;
        }

        @Override
        public void allowDiscard() {
            if (StreamPair.this.setFlagAndCheckMask(this.left ? 1 : 2, 3)) {
                StreamPair.this.upstream.allowDiscard();
            }
        }

        @Override
        public void cancelInput() {
            if (StreamPair.this.setFlagAndCheckMask(this.left ? 4 : 8, 12)) {
                StreamPair.this.upstream.cancelInput();
            }
        }

        final boolean isOtherSideCancelled() {
            return (StreamPair.this.flags.get() & (this.left ? 8 : 4)) != 0;
        }
    }
}

