/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.http.body.stream.ExtendedInputStream;
import io.micronaut.http.body.stream.PublisherAsBlocking;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.jspecify.annotations.Nullable;

@Internal
public final class PublisherAsStream
extends ExtendedInputStream {
    private final PublisherAsBlocking publisherAsBlocking;
    private ReadBuffer buffer;

    public PublisherAsStream(PublisherAsBlocking publisherAsBlocking) {
        this.publisherAsBlocking = publisherAsBlocking;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.populateBuffer()) {
            return -1;
        }
        int readable = this.buffer.readable();
        if (len >= readable) {
            this.buffer.toArray(b, off);
            this.buffer = null;
            return readable;
        }
        ReadBuffer piece = this.buffer.split(len);
        piece.toArray(b, off);
        return len;
    }

    @Override
    public byte @Nullable [] readSome() throws IOException {
        if (!this.populateBuffer()) {
            return null;
        }
        byte[] array = this.buffer.toArray();
        this.buffer = null;
        return array;
    }

    private boolean populateBuffer() throws IOException {
        while (this.buffer == null) {
            try {
                ReadBuffer o = this.publisherAsBlocking.take();
                if (o == null) {
                    Throwable failure = this.publisherAsBlocking.getFailure();
                    if (failure == null) {
                        return false;
                    }
                    throw new IOException(failure);
                }
                if (o.readable() == 0) {
                    o.close();
                    continue;
                }
                this.buffer = o;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
        return true;
    }

    @Override
    public void allowDiscard() {
    }

    @Override
    public void cancelInput() {
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
        this.publisherAsBlocking.close();
    }
}

