/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import io.micronaut.http.body.stream.ExtendedInputStream;
import io.micronaut.http.body.stream.StreamPair;
import java.io.IOException;
import java.io.InputStream;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public final class InputStreamByteBody
extends InternalByteBody
implements CloseableByteBody {
    private final Context context;
    private ExtendedInputStream stream;

    private InputStreamByteBody(Context context, ExtendedInputStream stream) {
        this.context = context;
        this.stream = stream;
    }

    public static @NonNull CloseableByteBody create(@NonNull InputStream stream, @NonNull OptionalLong length, @NonNull Executor ioExecutor, @NonNull ByteBufferFactory<?, ?> bufferFactory) {
        ArgumentUtils.requireNonNull((String)"bufferFactory", bufferFactory);
        return InputStreamByteBody.create(stream, length, ioExecutor, ByteBodyFactory.createDefault(bufferFactory));
    }

    public static @NonNull CloseableByteBody create(@NonNull InputStream stream, @NonNull OptionalLong length, @NonNull Executor ioExecutor, @NonNull ByteBodyFactory bodyFactory) {
        ArgumentUtils.requireNonNull((String)"stream", (Object)stream);
        ArgumentUtils.requireNonNull((String)"length", (Object)length);
        ArgumentUtils.requireNonNull((String)"ioExecutor", (Object)ioExecutor);
        ArgumentUtils.requireNonNull((String)"bodyFactory", (Object)bodyFactory);
        return new InputStreamByteBody(new Context(length, ioExecutor, bodyFactory), ExtendedInputStream.wrap(stream));
    }

    @Override
    public @NonNull CloseableByteBody allowDiscard() {
        if (this.stream == null) {
            this.failClaim();
        }
        this.stream.allowDiscard();
        return this;
    }

    @Override
    public void close() {
        if (this.stream != null) {
            this.recordClosed();
            this.stream.close();
            this.stream = null;
        }
    }

    @Override
    public @NonNull CloseableByteBody split(ByteBody.SplitBackpressureMode backpressureMode) {
        if (this.stream == null) {
            this.failClaim();
        }
        StreamPair.Pair pair = StreamPair.createStreamPair(this.stream, backpressureMode);
        this.stream = pair.left();
        return new InputStreamByteBody(this.context, pair.right());
    }

    @Override
    public @NonNull OptionalLong expectedLength() {
        return this.context.expectedLength();
    }

    @Override
    public @NonNull ExtendedInputStream toInputStream() {
        ExtendedInputStream s = this.stream;
        if (s == null) {
            this.failClaim();
        }
        this.recordPrimaryOp();
        this.stream = null;
        BaseSharedBuffer.logClaim();
        return s;
    }

    public @NonNull Flux<byte[]> toByteArrayPublisher() {
        ExtendedInputStream s = this.toInputStream();
        Sinks.Many sink = Sinks.many().unicast().onBackpressureBuffer();
        return sink.asFlux().doOnRequest(req -> {
            for (long remaining = req; remaining > 0L; --remaining) {
                byte[] arr;
                try {
                    arr = s.readSome();
                }
                catch (IOException e) {
                    sink.tryEmitError((Throwable)e);
                    break;
                }
                if (arr == null) {
                    sink.tryEmitComplete();
                    break;
                }
                sink.tryEmitNext((Object)arr);
            }
        }).doOnTerminate(s::close).doOnCancel(s::close).subscribeOn(Schedulers.fromExecutor((Executor)this.context.ioExecutor()));
    }

    @Override
    public @NonNull Publisher<ReadBuffer> toReadBufferPublisher() {
        return Flux.from(this.toByteArrayPublisher()).map(arg_0 -> ((ReadBufferFactory)this.context.bodyFactory.readBufferFactory()).adapt(arg_0));
    }

    @Override
    public @NonNull ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow() {
        ExtendedInputStream s = this.toInputStream();
        return ExecutionFlow.async((Executor)this.context.ioExecutor, () -> {
            ExtendedInputStream t = s;
            try {
                ExecutionFlow executionFlow = ExecutionFlow.just((Object)this.context.bodyFactory().copyOf(t));
                if (t != null) {
                    t.close();
                }
                return executionFlow;
            }
            catch (Throwable t$) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable x2) {
                            t$.addSuppressed(x2);
                        }
                    }
                    throw t$;
                }
                catch (Exception e) {
                    return ExecutionFlow.error((Throwable)e);
                }
            }
        });
    }

    @Override
    public @NonNull CloseableByteBody move() {
        return new InputStreamByteBody(this.context, this.toInputStream());
    }

    private record Context(OptionalLong expectedLength, Executor ioExecutor, ByteBodyFactory bodyFactory) {
    }
}

