/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.sse.Event;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import org.jspecify.annotations.NonNull;

@Internal
@Singleton
@Produces(value={"text/event-stream"})
@Consumes(value={"text/event-stream"})
final class TextStreamBodyWriter<T>
implements MessageBodyWriter<T> {
    private static final byte[] DATA_PREFIX = "data: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] EVENT_PREFIX = "event: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] ID_PREFIX = "id: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] RETRY_PREFIX = "retry: ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COMMENT_PREFIX = ": ".getBytes(StandardCharsets.UTF_8);
    private static final byte[] NEWLINE = "\n".getBytes(StandardCharsets.UTF_8);
    private static final List<MediaType> JSON_TYPE_LIST = List.of(MediaType.APPLICATION_JSON_TYPE);
    @Nullable
    private final MessageBodyWriter<Object> specificBodyWriter;
    private final MessageBodyHandlerRegistry registry;

    @Inject
    TextStreamBodyWriter(MessageBodyHandlerRegistry registry) {
        this(registry, null);
    }

    private TextStreamBodyWriter(MessageBodyHandlerRegistry registry, @Nullable MessageBodyWriter<Object> specificBodyWriter) {
        this.registry = registry;
        this.specificBodyWriter = specificBodyWriter;
    }

    @Override
    public MessageBodyWriter<T> createSpecific(Argument<T> type) {
        return new TextStreamBodyWriter<T>(this.registry, this.registry.findWriter(TextStreamBodyWriter.getBodyType(type), JSON_TYPE_LIST).orElse(null));
    }

    private static @NonNull Argument<Object> getBodyType(Argument<?> type) {
        if (type.getType().equals(Event.class)) {
            return type.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        }
        return type;
    }

    @Override
    public ByteBuffer<?> writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        ByteBufferOutput output = new ByteBufferOutput(bufferFactory);
        this.write0(type, mediaType, object, outgoingHeaders, output);
        return output.buffer;
    }

    @Override
    public void writeTo(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        this.write0(type, mediaType, object, outgoingHeaders, new StreamOutput(outputStream));
    }

    private void write0(Argument<T> type, MediaType mediaType, T object, MutableHeaders outgoingHeaders, Output output) {
        byte[] body;
        Event event;
        Argument bodyType = type;
        if (object instanceof Event) {
            Event e;
            event = e = (Event)object;
            bodyType = type.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        } else {
            event = Event.of(object);
        }
        Object data = event.getData();
        if (data instanceof CharSequence) {
            CharSequence s = (CharSequence)data;
            body = s.toString().getBytes(StandardCharsets.UTF_8);
        } else {
            MessageBodyWriter messageBodyWriter = this.specificBodyWriter;
            if (messageBodyWriter == null && (messageBodyWriter = (MessageBodyWriter)this.registry.findWriter(bodyType, JSON_TYPE_LIST).orElse(null)) == null) {
                bodyType = Argument.ofInstance(data);
                messageBodyWriter = this.registry.getWriter(bodyType, JSON_TYPE_LIST);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            messageBodyWriter.writeTo(bodyType, mediaType, data, outgoingHeaders, baos);
            body = baos.toByteArray();
        }
        TextStreamBodyWriter.writeAttribute(output, COMMENT_PREFIX, event.getComment());
        TextStreamBodyWriter.writeAttribute(output, ID_PREFIX, event.getId());
        TextStreamBodyWriter.writeAttribute(output, EVENT_PREFIX, event.getName());
        Duration retry = event.getRetry();
        if (retry != null) {
            TextStreamBodyWriter.writeAttribute(output, RETRY_PREFIX, String.valueOf(retry.toMillis()));
        }
        int start = 0;
        while (start < body.length) {
            int end = TextStreamBodyWriter.indexOf(body, (byte)10, start);
            if (end == -1) {
                end = body.length - 1;
            }
            output.write(DATA_PREFIX).write(body, start, end - start + 1);
            start = end + 1;
        }
        output.write(NEWLINE).write(NEWLINE);
    }

    private static int indexOf(byte[] haystack, byte needle, int start) {
        for (int i = start; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }

    private static void writeAttribute(Output eventData, byte[] attribute, String value) {
        if (value != null) {
            eventData.write(attribute).write(value, StandardCharsets.UTF_8).write(NEWLINE);
        }
    }

    private static final class ByteBufferOutput
    implements Output {
        final ByteBufferFactory<?, ?> bufferFactory;
        ByteBuffer<?> buffer;

        ByteBufferOutput(ByteBufferFactory<?, ?> bufferFactory) {
            this.bufferFactory = bufferFactory;
        }

        @Override
        public void allocate(int expectedLength) {
            this.buffer = this.bufferFactory.buffer(expectedLength);
        }

        @Override
        public Output write(byte[] b) {
            this.buffer.write(b);
            return this;
        }

        @Override
        public Output write(byte[] b, int off, int len) {
            this.buffer.write(b, off, len);
            return this;
        }

        @Override
        public Output write(String value, Charset charset) {
            this.buffer.write((CharSequence)value, charset);
            return this;
        }
    }

    private static sealed interface Output
    permits ByteBufferOutput, StreamOutput {
        public void allocate(int var1);

        public Output write(byte[] var1);

        public Output write(byte[] var1, int var2, int var3);

        public Output write(String var1, Charset var2);
    }

    private record StreamOutput(OutputStream stream) implements Output
    {
        @Override
        public void allocate(int expectedLength) {
        }

        private void handle(IOException ioe) {
            throw new CodecException("Failed to write SSE data", ioe);
        }

        @Override
        public Output write(byte[] b) {
            try {
                this.stream.write(b);
            }
            catch (IOException e) {
                this.handle(e);
            }
            return this;
        }

        @Override
        public Output write(byte[] b, int off, int len) {
            try {
                this.stream.write(b, off, len);
            }
            catch (IOException e) {
                this.handle(e);
            }
            return this;
        }

        @Override
        public Output write(String value, Charset charset) {
            try {
                this.stream.write(value.getBytes(charset));
            }
            catch (IOException e) {
                this.handle(e);
            }
            return this;
        }
    }
}

