/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.body.TypedMessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import org.jspecify.annotations.NonNull;

@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
@Singleton
@Internal
final class TextPlainObjectBodyWriter
implements TypedMessageBodyWriter<Object>,
ResponseBodyWriter<Object> {
    TextPlainObjectBodyWriter() {
    }

    @Override
    public Argument<Object> getType() {
        return Argument.OBJECT_ARGUMENT;
    }

    @Override
    public boolean isWriteable(Argument<Object> type, MediaType mediaType) {
        return ClassUtils.isJavaBasicType((Class)type.getType());
    }

    @Override
    public void writeTo(Argument<Object> type, MediaType mediaType, Object object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        outgoingHeaders.setIfMissing((CharSequence)"Content-Type", (CharSequence)"text/plain");
        try {
            outputStream.write(object.toString().getBytes(MessageBodyWriter.getCharset(mediaType, (Headers)outgoingHeaders)));
        }
        catch (IOException e) {
            throw new CodecException("Error writing body text: " + e.getMessage(), e);
        }
    }

    @Override
    public @NonNull CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<Object> type, @NonNull MediaType mediaType, Object object) throws CodecException {
        CharSequence charSequence;
        if (object instanceof CharSequence) {
            CharSequence cs = (CharSequence)object;
            charSequence = cs;
        } else {
            charSequence = object.toString();
        }
        return bodyFactory.copyOf(charSequence, MessageBodyWriter.getCharset(mediaType, response.getHeaders()));
    }
}

