/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.ByteBodyHttpResponseWrapper;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.codec.CodecException;
import java.io.OutputStream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
final class ResponseBodyWriterWrapper<T>
implements ResponseBodyWriter<T> {
    private final MessageBodyWriter<T> wrapped;

    ResponseBodyWriterWrapper(MessageBodyWriter<T> wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public boolean isWriteable(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return this.wrapped.isWriteable(type, mediaType);
    }

    @Override
    public MessageBodyWriter<T> createSpecific(@NonNull Argument<T> type) {
        return this.wrapped.createSpecific(type);
    }

    @Override
    public boolean isBlocking() {
        return this.wrapped.isBlocking();
    }

    @Override
    public void writeTo(@NonNull Argument<T> type, @NonNull MediaType mediaType, T object, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        this.wrapped.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
    }

    @Override
    public @NonNull ByteBuffer<?> writeTo(@NonNull Argument<T> type, @NonNull MediaType mediaType, T object, @NonNull MutableHeaders outgoingHeaders, @NonNull ByteBufferFactory<?, ?> bufferFactory) throws CodecException {
        return this.wrapped.writeTo(type, mediaType, object, outgoingHeaders, bufferFactory);
    }

    @Override
    public @NonNull ByteBodyHttpResponse<?> write(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<T> httpResponse, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object) throws CodecException {
        return ByteBodyHttpResponseWrapper.wrap(httpResponse, this.writePiece(bodyFactory, (MutableHttpHeaders)httpResponse.getHeaders(), type, mediaType, object));
    }

    @Override
    public CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object) {
        return this.writePiece(bodyFactory, (MutableHttpHeaders)response.toMutableResponse().getHeaders(), type, mediaType, object);
    }

    private @NonNull CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, MutableHttpHeaders headers, @NonNull Argument<T> type, @NonNull MediaType mediaType, T object) {
        return bodyFactory.buffer(s -> this.writeTo(type, mediaType, object, (MutableHeaders)headers, (OutputStream)s));
    }
}

