/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.execution.CompletableFutureExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Internal
public abstract class InternalByteBody
implements ByteBody {
    private static final String TRACK_OPERATIONS_PROPERTY = ByteBody.class.getName() + ".trackOperations";
    private static final boolean TRACK_OPERATIONS = Boolean.getBoolean(TRACK_OPERATIONS_PROPERTY);
    private @Nullable Throwable primaryOpTrace;
    private @Nullable Throwable closeTrace;

    protected final void recordPrimaryOp() {
        if (TRACK_OPERATIONS && this.primaryOpTrace == null) {
            this.primaryOpTrace = new Exception("First ByteBody primary operation performed here");
        }
    }

    protected final void recordClosed() {
        if (TRACK_OPERATIONS && this.closeTrace == null) {
            this.closeTrace = new Exception("ByteBody closed here");
        }
    }

    public abstract @NonNull ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow();

    @Override
    public final CompletableFuture<? extends CloseableAvailableByteBody> buffer() {
        return this.bufferFlow().toCompletableFuture();
    }

    @Override
    public @NonNull Publisher<byte[]> toByteArrayPublisher() {
        return Flux.from(this.toReadBufferPublisher()).doOnDiscard(ReadBuffer.class, ReadBuffer::close).map(ReadBuffer::toArray);
    }

    @Override
    public abstract @NonNull Publisher<ReadBuffer> toReadBufferPublisher();

    @Contract(value="-> fail")
    protected final void failClaim() {
        IllegalStateException e = new IllegalStateException("Request body has already been claimed: Two conflicting sites are trying to access the request body. If this is intentional, the first user must ByteBody#split the body. To find out where the body was claimed, enable the -D" + TRACK_OPERATIONS_PROPERTY + "=true system property.");
        if (TRACK_OPERATIONS) {
            if (this.primaryOpTrace != null) {
                e.addSuppressed(this.primaryOpTrace);
            }
            if (this.closeTrace != null) {
                e.addSuppressed(this.closeTrace);
            }
        }
        throw e;
    }

    public static ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow(ByteBody body) {
        if (body instanceof InternalByteBody) {
            InternalByteBody internal = (InternalByteBody)body;
            return internal.bufferFlow();
        }
        return CompletableFutureExecutionFlow.just(body.buffer());
    }
}

