/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.body.AbstractMessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.inject.BeanType;
import io.micronaut.inject.QualifiedBeanType;
import io.micronaut.inject.qualifiers.FilteringQualifier;
import io.micronaut.inject.qualifiers.MatchArgumentQualifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

@Singleton
@BootstrapContextCompatible
public final class DefaultMessageBodyHandlerRegistry
extends AbstractMessageBodyHandlerRegistry {
    private final BeanContext beanLocator;
    private final List<CodecConfiguration> codecConfigurations;

    DefaultMessageBodyHandlerRegistry(BeanContext beanLocator, List<CodecConfiguration> codecConfigurations) {
        this.beanLocator = beanLocator;
        this.codecConfigurations = codecConfigurations;
    }

    @Override
    protected <T> MessageBodyReader<T> findReaderImpl(Argument<T> type, List<MediaType> mediaTypes) {
        List<MediaType> resolvedMediaTypes = this.resolveMediaTypes(mediaTypes);
        return this.beanLocator.getBeansOfType(Argument.of(MessageBodyReader.class), Qualifiers.byQualifiers((Qualifier[])new Qualifier[]{new MediaTypeQualifier(Argument.of(MessageBodyReader.class, (Argument[])new Argument[]{type}), resolvedMediaTypes, Consumes.class), MatchArgumentQualifier.covariant(MessageBodyReader.class, type)})).stream().filter(reader -> resolvedMediaTypes.stream().anyMatch(mediaType -> reader.isReadable(type, (MediaType)mediaType))).findFirst().orElse(null);
    }

    private @NonNull List<MediaType> resolveMediaTypes(List<MediaType> mediaTypes) {
        if (this.codecConfigurations.isEmpty()) {
            return mediaTypes;
        }
        ArrayList<MediaType> resolvedMediaTypes = new ArrayList<MediaType>(mediaTypes.size());
        resolvedMediaTypes.addAll(mediaTypes);
        block0: for (MediaType mediaType : mediaTypes) {
            for (CodecConfiguration codecConfiguration : this.codecConfigurations) {
                List<MediaType> additionalTypes = codecConfiguration.getAdditionalTypes();
                if (!additionalTypes.contains(mediaType)) continue;
                this.beanLocator.findBean(MediaTypeCodec.class, Qualifiers.byName((String)codecConfiguration.getName())).ifPresent(codec -> resolvedMediaTypes.addAll(codec.getMediaTypes()));
                continue block0;
            }
        }
        return resolvedMediaTypes;
    }

    @Override
    protected <T> MessageBodyWriter<T> findWriterImpl(Argument<T> type, List<MediaType> mediaTypes) {
        List<MediaType> resolvedMediaTypes = this.resolveMediaTypes(mediaTypes);
        return this.beanLocator.getBeansOfType(Argument.of(MessageBodyWriter.class), Qualifiers.byQualifiers((Qualifier[])new Qualifier[]{new MediaTypeQualifier(Argument.of(MessageBodyWriter.class, (Argument[])new Argument[]{type}), resolvedMediaTypes, Produces.class), MatchArgumentQualifier.contravariant(MessageBodyWriter.class, type)})).stream().filter(writer -> resolvedMediaTypes.stream().anyMatch(mediaType -> writer.isWriteable(type, (MediaType)mediaType))).findFirst().orElse(null);
    }

    private static final class MediaTypeQualifier<T>
    extends FilteringQualifier<T> {
        private final Argument<?> type;
        private final List<MediaType> mediaTypes;
        private final Class<? extends Annotation> annotationType;

        private MediaTypeQualifier(Argument<?> type, List<MediaType> mediaTypes, Class<? extends Annotation> annotationType) {
            this.type = type;
            this.mediaTypes = mediaTypes;
            this.annotationType = annotationType;
        }

        public <K extends BeanType<T>> Collection<K> filter(Class<T> beanType, Collection<K> candidates) {
            ArrayList<BeanType> all = new ArrayList<BeanType>(candidates.size());
            block0: for (BeanType candidate : candidates) {
                String[] applicableTypes = candidate.getAnnotationMetadata().stringValues(this.annotationType);
                if (applicableTypes.length == 0) {
                    all.add(candidate);
                    continue;
                }
                for (String mt : applicableTypes) {
                    MediaType mediaType = new MediaType(mt);
                    for (MediaType m : this.mediaTypes) {
                        if (!m.matches(mediaType)) continue;
                        all.add(candidate);
                        continue block0;
                    }
                }
            }
            all.sort(Comparator.comparingInt(this::findOrder).reversed());
            return all;
        }

        public <BT extends QualifiedBeanType<T>> Collection<BT> filterQualified(Class<T> beanType, Collection<BT> candidates) {
            return this.filter(beanType, candidates);
        }

        private int findOrder(BeanType<?> beanType) {
            int order = 0;
            String[] applicableTypes = beanType.getAnnotationMetadata().stringValues(this.annotationType);
            int size = this.mediaTypes.size();
            for (String mt : applicableTypes) {
                int index = this.mediaTypes.indexOf(new MediaType(mt));
                if (index == -1) continue;
                int compareValue = size - index;
                order = Integer.max(order, compareValue);
            }
            return order;
        }

        private static boolean isInvalidType(List<Argument<?>> consumedType, Argument<?> requiredType) {
            Argument<?> argument = consumedType.get(0);
            return !argument.isTypeVariable() && !argument.isAssignableFrom(requiredType.getType());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            MediaTypeQualifier that = (MediaTypeQualifier)((Object)o);
            return this.type.equalsType(that.type) && this.mediaTypes.equals(that.mediaTypes);
        }

        public int hashCode() {
            return Objects.hash(this.type.typeHashCode(), this.mediaTypes);
        }

        public String toString() {
            return "MediaTypeQualifier[type=" + String.valueOf(this.type) + ", mediaTypes=" + String.valueOf(this.mediaTypes) + ", annotationType=" + String.valueOf(this.annotationType) + "]";
        }
    }
}

