/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.body.ByteBodyFactory;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.body.ResponseBodyWriter;
import io.micronaut.http.body.TypedMessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jspecify.annotations.NonNull;

@Singleton
@Internal
public final class CharSequenceBodyWriter
implements TypedMessageBodyWriter<CharSequence>,
ResponseBodyWriter<CharSequence> {
    private final Charset defaultCharset;

    @Inject
    CharSequenceBodyWriter(ApplicationConfiguration applicationConfiguration) {
        this(applicationConfiguration.getDefaultCharset());
    }

    public CharSequenceBodyWriter(Charset defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    @Override
    public void writeTo(Argument<CharSequence> type, MediaType mediaType, CharSequence object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        if (mediaType != null) {
            ((MutableHttpHeaders)outgoingHeaders).contentTypeIfMissing(mediaType);
        }
        try {
            outputStream.write(object.toString().getBytes(MessageBodyWriter.findCharset(mediaType, (Headers)outgoingHeaders).orElse(this.defaultCharset)));
        }
        catch (IOException e) {
            throw new CodecException("Error writing body text: " + e.getMessage(), e);
        }
    }

    @Override
    public CloseableByteBody writePiece(@NonNull ByteBodyFactory bodyFactory, @NonNull HttpRequest<?> request, @NonNull HttpResponse<?> response, @NonNull Argument<CharSequence> type, @NonNull MediaType mediaType, CharSequence object) {
        return bodyFactory.copyOf(object, MessageBodyWriter.getCharset(mediaType, response.getHeaders()));
    }

    @Override
    public Argument<CharSequence> getType() {
        return Argument.of(CharSequence.class);
    }
}

