/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public interface ByteBody {
    default public @NonNull CloseableByteBody split() {
        return this.split(SplitBackpressureMode.SLOWEST);
    }

    public @NonNull CloseableByteBody split(@NonNull SplitBackpressureMode var1);

    @Contract(value="-> this")
    default public @NonNull ByteBody allowDiscard() {
        return this;
    }

    public @NonNull OptionalLong expectedLength();

    public @NonNull InputStream toInputStream();

    public @NonNull Publisher<byte[]> toByteArrayPublisher();

    default public @NonNull Publisher<ReadBuffer> toReadBufferPublisher() {
        return Flux.from(this.toByteArrayPublisher()).map(arg_0 -> ((ReadBufferFactory)ReadBufferFactory.getJdkFactory()).adapt(arg_0));
    }

    default public @NonNull Publisher<ByteBuffer<?>> toByteBufferPublisher() {
        return Flux.from(this.toReadBufferPublisher()).doOnDiscard(ReadBuffer.class, ReadBuffer::close).map(rb -> {
            try (ReadBuffer twrVar0$ = rb;){
                ByteBuffer byteBuffer = rb.toByteBuffer();
                return byteBuffer;
            }
        });
    }

    public @NonNull CompletableFuture<? extends CloseableAvailableByteBody> buffer();

    public @NonNull CloseableByteBody move();

    default public void touch() {
    }

    public static enum SplitBackpressureMode {
        SLOWEST,
        FASTEST,
        ORIGINAL,
        NEW;

    }

    public static final class BodyDiscardedException
    extends IOException {
        static final BodyDiscardedException INSTANCE = new BodyDiscardedException();

        BodyDiscardedException() {
        }

        public static BodyDiscardedException create() {
            return INSTANCE;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

