/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.OptionalLong;
import org.jspecify.annotations.NonNull;
import org.reactivestreams.Publisher;

public interface AvailableByteBody
extends ByteBody {
    @Override
    public @NonNull CloseableAvailableByteBody split();

    @Override
    @Deprecated
    default public @NonNull CloseableAvailableByteBody split(@NonNull ByteBody.SplitBackpressureMode backpressureMode) {
        return this.split();
    }

    @Override
    @Deprecated
    default public @NonNull AvailableByteBody allowDiscard() {
        return this;
    }

    public long length();

    @Override
    @Deprecated
    default public @NonNull OptionalLong expectedLength() {
        return OptionalLong.of(this.length());
    }

    public byte @NonNull [] toByteArray();

    default public @NonNull ReadBuffer toReadBuffer() {
        return ReadBufferFactory.getJdkFactory().adapt(this.toByteArray());
    }

    default public @NonNull ByteBuffer<?> toByteBuffer() {
        try (ReadBuffer rb = this.toReadBuffer();){
            ByteBuffer byteBuffer = rb.toByteBuffer();
            return byteBuffer;
        }
    }

    @Override
    default public @NonNull InputStream toInputStream() {
        try (ReadBuffer rb = this.toReadBuffer();){
            InputStream inputStream = rb.toInputStream();
            return inputStream;
        }
    }

    default public @NonNull String toString(@NonNull Charset charset) {
        try (ReadBuffer rb = this.toReadBuffer();){
            String string = rb.toString(charset);
            return string;
        }
    }

    @Override
    @Deprecated
    default public @NonNull Publisher<ByteBuffer<?>> toByteBufferPublisher() {
        return Publishers.just(this.toByteBuffer());
    }

    @Override
    @Deprecated
    default public @NonNull Publisher<byte[]> toByteArrayPublisher() {
        return Publishers.just((Object)this.toByteArray());
    }

    @Override
    @Deprecated
    default public @NonNull Publisher<ReadBuffer> toReadBufferPublisher() {
        return Publishers.just((Object)this.toReadBuffer());
    }
}

