/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import io.micronaut.http.body.stream.BufferConsumer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public class AbstractBodyAdapter
implements BufferConsumer.Upstream,
Subscriber<ReadBuffer> {
    private BaseSharedBuffer sharedBuffer;
    private volatile Subscription subscription;
    private final AtomicLong demand = new AtomicLong(1L);
    private final Publisher<ReadBuffer> source;
    private final @Nullable Runnable onDiscard;
    private volatile boolean cancelled;

    public AbstractBodyAdapter(@NonNull Publisher<ReadBuffer> source, @Nullable Runnable onDiscard) {
        this.source = source;
        this.onDiscard = onDiscard;
    }

    public final void setSharedBuffer(BaseSharedBuffer sharedBuffer) {
        this.sharedBuffer = sharedBuffer;
    }

    @Override
    public final void start() {
        this.source.subscribe((Subscriber)this);
    }

    @Override
    public final void onBytesConsumed(long bytesConsumed) {
        if (bytesConsumed < 0L) {
            throw new IllegalArgumentException("Negative bytes consumed");
        }
        LongUnaryOperator add = l -> l + bytesConsumed < l ? Long.MAX_VALUE : l + bytesConsumed;
        long oldDemand = this.demand.getAndUpdate(add);
        long newDemand = add.applyAsLong(oldDemand);
        if (oldDemand <= 0L && newDemand > 0L) {
            this.subscription.request(1L);
        }
    }

    @Override
    public final void allowDiscard() {
        this.cancelled = true;
        if (this.subscription != null) {
            this.subscription.cancel();
        }
        if (this.onDiscard != null) {
            this.onDiscard.run();
        }
    }

    @Override
    public final void disregardBackpressure() {
        this.demand.set(Long.MAX_VALUE);
        if (this.subscription != null) {
            this.subscription.request(Long.MAX_VALUE);
        }
    }

    public final void onSubscribe(Subscription s) {
        this.subscription = s;
        if (this.cancelled) {
            s.cancel();
        } else {
            s.request(1L);
        }
    }

    public void onNext(ReadBuffer buffer) {
        long newDemand = this.demand.addAndGet(-buffer.readable());
        this.sharedBuffer.add(buffer);
        if (newDemand > 0L) {
            this.subscription.request(1L);
        }
    }

    public void onError(Throwable t) {
        this.sharedBuffer.error(t);
    }

    public void onComplete() {
        this.sharedBuffer.complete();
    }
}

