/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.AbstractArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.http.BasicHttpAttributes;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.uri.UriMatchVariable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class QueryValueArgumentBinder<T>
extends AbstractArgumentBinder<T>
implements AnnotatedRequestArgumentBinder<QueryValue, T> {
    public QueryValueArgumentBinder(ConversionService conversionService) {
        super(conversionService);
    }

    public QueryValueArgumentBinder(ConversionService conversionService, Argument<T> argument) {
        super(conversionService, argument);
    }

    @Override
    public RequestArgumentBinder<T> createSpecific(Argument<T> argument) {
        return new QueryValueArgumentBinder<T>(this.conversionService, argument);
    }

    public Class<QueryValue> getAnnotationType() {
        return QueryValue.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        HttpParameters parameters = source.getParameters();
        Argument argument = context.getArgument();
        AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
        if (source.getMethod().permitsRequestBody() && !annotationMetadata.hasAnnotation(QueryValue.class)) {
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        ArgumentBinder.BindingResult<T> bindSimpleResult = this.bindSimple(context, source, annotationMetadata, parameters, argument);
        if (bindSimpleResult.isSatisfied()) {
            return bindSimpleResult;
        }
        return this.bindPojo(context, parameters, argument);
    }

    private ArgumentBinder.BindingResult<T> bindSimple(ArgumentConversionContext<T> context, HttpRequest<?> source, AnnotationMetadata annotationMetadata, ConvertibleMultiValues<String> parameters, Argument<T> argument) {
        Optional multiValueConversion = annotationMetadata.hasAnnotation(Format.class) ? this.conversionService.convert(parameters, context) : Optional.empty();
        if (multiValueConversion.isPresent()) {
            return () -> multiValueConversion;
        }
        String parameterName = this.resolvedParameterName(argument);
        boolean bindAll = BasicHttpAttributes.getRouteMatchInfo(source).map(umi -> {
            UriMatchVariable uriMatchVariable = umi.getVariableMap().get(parameterName);
            return uriMatchVariable != null && uriMatchVariable.isExploded();
        }).orElse(false);
        if (bindAll) {
            Object value;
            if (Iterable.class.isAssignableFrom(argument.getType())) {
                value = this.doResolve((ArgumentConversionContext)context, (ConvertibleValues)parameters);
                if (value == null) {
                    value = Collections.emptyList();
                }
            } else {
                value = parameters.asMap();
            }
            return this.doConvert(value, context);
        }
        return this.doBind((ArgumentConversionContext)context, (ConvertibleValues)parameters, ArgumentBinder.BindingResult.unsatisfied());
    }

    private ArgumentBinder.BindingResult<T> bindPojo(ArgumentConversionContext<T> context, ConvertibleMultiValues<String> parameters, Argument<T> argument) {
        Optional introspectionOpt = BeanIntrospector.SHARED.findIntrospection(argument.getType());
        if (introspectionOpt.isEmpty()) {
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        BeanIntrospection introspection = (BeanIntrospection)introspectionOpt.get();
        BeanIntrospection.Builder introspectionBuilder = introspection.builder();
        Argument[] builderArguments = introspectionBuilder.getBuilderArguments();
        for (int index = 0; index < builderArguments.length; ++index) {
            ConversionError conversionError;
            Optional converted;
            Argument builderArg = builderArguments[index];
            String propertyName = builderArg.getName();
            List values = parameters.getAll((CharSequence)propertyName);
            boolean hasNoValue = values.isEmpty();
            String defaultValue = hasNoValue ? (String)builderArg.getAnnotationMetadata().stringValue(Bindable.class, "defaultValue").orElse(null) : null;
            ArgumentConversionContext conversionContext = context.with(builderArg);
            Optional optional = converted = hasNoValue ? this.conversionService.convert((Object)defaultValue, conversionContext) : this.conversionService.convert((Object)values, conversionContext);
            if (converted.isPresent()) {
                try {
                    Argument rawArg = builderArg;
                    introspectionBuilder.with(index, rawArg, converted.get());
                    continue;
                }
                catch (Exception e) {
                    context.reject((Object)builderArg, e);
                    return ArgumentBinder.BindingResult.unsatisfied();
                }
            }
            if (!conversionContext.hasErrors() || (conversionError = (ConversionError)conversionContext.getLastError().orElse(null)) == null) continue;
            Exception cause = conversionError.getCause();
            context.reject((Object)builderArg, cause);
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        try {
            Object instance = introspectionBuilder.build();
            return () -> Optional.of(instance);
        }
        catch (Exception e) {
            context.reject(argument, e);
            return ArgumentBinder.BindingResult.unsatisfied();
        }
    }

    protected String getParameterName(Argument<T> argument) {
        return argument.getAnnotationMetadata().stringValue(QueryValue.class).orElse(argument.getName());
    }
}

