/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ImmutableArgumentConversionContext;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.http.annotation.Produces;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeHint(value={MediaType[].class})
public class MediaType
implements CharSequence {
    public static final String EXTENSION_JSON = "json";
    public static final String EXTENSION_XML = "xml";
    public static final String EXTENSION_PDF = "pdf";
    public static final String EXTENSION_XLSX = "xlsx";
    public static final String EXTENSION_XLS = "xls";
    public static final String EXTENSION_ODS = "ods";
    public static final String EXTENSION_DOCX = "docx";
    public static final String EXTENSION_DOC = "doc";
    public static final String EXTENSION_ODT = "odt";
    public static final String EXTENSION_PPTX = "pptx";
    public static final String EXTENSION_PPT = "ppt";
    public static final String EXTENSION_ODP = "odp";
    public static final String EXTENSION_GPX = "gpx";
    public static final String EXTENSION_ZIP = "zip";
    public static final String EXTENSION_GZIP = "gz";
    public static final MediaType[] EMPTY_ARRAY = new MediaType[0];
    public static final String ALL = "*/*";
    public static final MediaType ALL_TYPE = new MediaType("*/*", "all");
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MediaType MULTIPART_FORM_DATA_TYPE = new MediaType("multipart/form-data");
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_FORM_URLENCODED_TYPE;
    public static final MediaType FORM;
    public static final String APPLICATION_XHTML = "application/xhtml+xml";
    public static final MediaType APPLICATION_XHTML_TYPE;
    public static final String APPLICATION_XML = "application/xml";
    public static final MediaType APPLICATION_XML_TYPE;
    public static final String APPLICATION_JSON_GITHUB = "application/vnd.github+json";
    public static final MediaType APPLICATION_JSON_GITHUB_TYPE;
    public static final String APPLICATION_JSON_FEED = "application/feed+json";
    public static final MediaType APPLICATION_JSON_FEED_TYPE;
    public static final String APPLICATION_JSON_PATCH = "application/json-patch+json";
    public static final MediaType APPLICATION_JSON_PATCH_TYPE;
    public static final String APPLICATION_JSON_MERGE_PATCH = "application/merge-patch+json";
    public static final MediaType APPLICATION_JSON_MERGE_PATCH_TYPE;
    public static final String APPLICATION_JSON_PROBLEM = "application/problem+json";
    public static final MediaType APPLICATION_JSON_PROBLEM_TYPE;
    public static final String APPLICATION_JSON_SCHEMA = "application/schema+json";
    public static final MediaType APPLICATION_JSON_SCHEMA_TYPE;
    public static final String APPLICATION_JSON = "application/json";
    public static final MediaType APPLICATION_JSON_TYPE;
    public static final String APPLICATION_YAML = "application/x-yaml";
    public static final MediaType APPLICATION_YAML_TYPE;
    public static final String MICROSOFT_EXCEL_OPEN_XML = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    public static final MediaType MICROSOFT_EXCEL_OPEN_XML_TYPE;
    public static final String MICROSOFT_EXCEL = "application/vnd.ms-excel";
    public static final MediaType MICROSOFT_EXCEL_TYPE;
    public static final String OPEN_DOCUMENT_SPREADSHEET = "application/vnd.oasis.opendocument.spreadsheet";
    public static final MediaType OPEN_DOCUMENT_SPREADSHEET_TYPE;
    public static final String MICROSOFT_WORD_OPEN_XML = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final MediaType MICROSOFT_WORD_OPEN_XML_TYPE;
    public static final String MICROSOFT_WORD = "application/msword";
    public static final MediaType MICROSOFT_WORD_TYPE;
    public static final String OPEN_DOCUMENT_TEXT = "application/vnd.oasis.opendocument.text";
    public static final MediaType OPEN_DOCUMENT_TEXT_TYPE;
    public static final String MICROSOFT_POWERPOINT_OPEN_XML = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    public static final MediaType MICROSOFT_POWERPOINT_OPEN_XML_TYPE;
    public static final String MICROSOFT_POWERPOINT = "application/vnd.ms-powerpoint";
    public static final MediaType MICROSOFT_POWERPOINT_TYPE;
    public static final String OPEN_DOCUMENT_PRESENTATION = "application/vnd.oasis.opendocument.presentation";
    public static final MediaType OPEN_DOCUMENT_PRESENTATION_TYPE;
    public static final String APPLICATION_HAL_JSON = "application/hal+json";
    public static final MediaType APPLICATION_HAL_JSON_TYPE;
    public static final String APPLICATION_HAL_XML = "application/hal+xml";
    public static final MediaType APPLICATION_HAL_XML_TYPE;
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final MediaType APPLICATION_ATOM_XML_TYPE;
    public static final String APPLICATION_VND_ERROR = "application/vnd.error+json";
    public static final MediaType APPLICATION_VND_ERROR_TYPE;
    public static final String APPLICATION_JSON_STREAM = "application/x-json-stream";
    public static final MediaType APPLICATION_JSON_STREAM_TYPE;
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final MediaType APPLICATION_OCTET_STREAM_TYPE;
    public static final String APPLICATION_GRAPHQL = "application/graphql";
    public static final MediaType APPLICATION_GRAPHQL_TYPE;
    public static final String APPLICATION_GPX_XML = "application/gpx+xml";
    public static final MediaType GPX_XML_TYPE;
    public static final String APPLICATION_ZIP = "application/zip";
    public static final MediaType ZIP_TYPE;
    public static final String APPLICATION_GZIP = "application/gzip";
    public static final MediaType GZIP_TYPE;
    public static final String APPLICATION_YANG = "application/yang";
    public static final MediaType YANG_TYPE;
    public static final String APPLICATION_CUE = "application/x-cue";
    public static final MediaType CUE_TYPE;
    public static final String APPLICATION_TOML = "application/toml";
    public static final MediaType TOML_TYPE;
    public static final String APPLICATION_RTF = "application/rtf";
    public static final MediaType RTF_TYPE;
    public static final String APPLICATION_ZLIB = "application/zlib";
    public static final MediaType ZLIB_TYPE;
    public static final String APPLICATION_ZSTD = "application/zstd";
    public static final MediaType ZSTD_TYPE;
    public static final String APPLICATION_PDF = "application/pdf";
    public static final MediaType APPLICATION_PDF_TYPE;
    public static final String TEXT_HTML = "text/html";
    public static final MediaType TEXT_HTML_TYPE;
    public static final String TEXT_CSV = "text/csv";
    public static final MediaType TEXT_CSV_TYPE;
    public static final String TEXT_CSS = "text/css";
    public static final MediaType TEXT_CSS_TYPE;
    public static final String TEXT_XML = "text/xml";
    public static final MediaType TEXT_XML_TYPE;
    public static final String TEXT_JSON = "text/json";
    public static final MediaType TEXT_JSON_TYPE;
    public static final String TEXT_JAVASCRIPT = "text/javascript";
    public static final MediaType TEXT_JAVASCRIPT_TYPE;
    public static final String TEXT_ECMASCRIPT = "text/ecmascript";
    public static final MediaType TEXT_ECMASCRIPT_TYPE;
    public static final String TEXT_PLAIN = "text/plain";
    public static final MediaType TEXT_PLAIN_TYPE;
    public static final String TEXT_MARKDOWN = "text/markdown";
    public static final MediaType TEXT_MARKDOWN_TYPE;
    public static final String TEXT_EVENT_STREAM = "text/event-stream";
    public static final MediaType TEXT_EVENT_STREAM_TYPE;
    public static final String IMAGE_APNG = "image/apng";
    public static final MediaType IMAGE_APNG_TYPE;
    public static final String IMAGE_BMP = "image/bmp";
    public static final MediaType IMAGE_BMP_TYPE;
    public static final String IMAGE_X_ICON = "image/x-icon";
    public static final MediaType IMAGE_X_ICON_TYPE;
    public static final String IMAGE_TIFF = "image/tiff";
    public static final MediaType IMAGE_TIFF_TYPE;
    public static final String IMAGE_AVIF = "image/avif";
    public static final MediaType IMAGE_AVIF_TYPE;
    public static final String IMAGE_SVG = "image/svg+xml";
    public static final MediaType IMAGE_SVG_TYPE;
    public static final String IMAGE_XBM = "image/xbm";
    public static final MediaType IMAGE_XBM_TYPE;
    public static final String IMAGE_PNG = "image/png";
    public static final MediaType IMAGE_PNG_TYPE;
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final MediaType IMAGE_JPEG_TYPE;
    public static final String IMAGE_GIF = "image/gif";
    public static final MediaType IMAGE_GIF_TYPE;
    public static final String IMAGE_WEBP = "image/webp";
    public static final MediaType IMAGE_WEBP_TYPE;
    public static final String IMAGE_WMF = "image/wmf";
    public static final MediaType IMAGE_WMF_TYPE;
    public static final String CHARSET_PARAMETER = "charset";
    public static final String Q_PARAMETER = "q";
    public static final String V_PARAMETER = "v";
    @Internal
    static final Argument<MediaType> ARGUMENT;
    @Internal
    static final ArgumentConversionContext<MediaType> CONVERSION_CONTEXT;
    private static final char SEMICOLON = ';';
    private static final String WILDCARD = "*";
    private static final String MIME_TYPES_FILE_NAME = "META-INF/http/mime.types";
    private static Map<String, String> mediaTypeFileExtensions;
    private static final List<Pattern> textTypePatterns;
    protected final String name;
    protected final String subtype;
    protected final String type;
    protected final String extension;
    protected final Map<CharSequence, String> parameters;
    private final String strRepr;
    private final String lowerName;
    private BigDecimal qualityNumberField = BigDecimal.ONE;
    private boolean valid;

    public MediaType(@NonNull String name) {
        this(name, null, Collections.emptyMap());
    }

    public MediaType(@NonNull String name, @Nullable Map<String, String> params) {
        this(name, null, params);
    }

    public MediaType(@NonNull String name, @Nullable String extension) {
        this(name, extension, Collections.emptyMap());
    }

    public MediaType(@NonNull String name, @Nullable String extension, @Nullable Map<String, String> params) {
        int j;
        String withoutArgs;
        if (name == null) {
            throw new IllegalArgumentException("Argument [name] cannot be null");
        }
        Iterator splitIt = StringUtils.splitOmitEmptyStringsIterator((CharSequence)(name = name.trim()), (char)';');
        if (splitIt.hasNext()) {
            withoutArgs = (String)splitIt.next();
            if (splitIt.hasNext()) {
                Map<String, String> parameters = null;
                while (splitIt.hasNext()) {
                    String paramExpression = (String)splitIt.next();
                    int i = paramExpression.indexOf(61);
                    if (i <= -1) continue;
                    String paramName = paramExpression.substring(0, i).trim();
                    String paramValue = paramExpression.substring(i + 1).trim();
                    if (Q_PARAMETER.equals(paramName)) {
                        this.qualityNumberField = new BigDecimal(paramValue);
                    }
                    if (parameters == null) {
                        parameters = new LinkedHashMap();
                    }
                    parameters.put(paramName, paramValue);
                }
                if (parameters == null) {
                    parameters = Collections.emptyMap();
                }
                this.parameters = parameters;
            } else {
                this.parameters = params == null ? Collections.emptyMap() : params;
            }
        } else {
            this.parameters = params == null ? Collections.emptyMap() : params;
            withoutArgs = name;
        }
        this.name = withoutArgs;
        this.lowerName = withoutArgs.toLowerCase(Locale.ROOT);
        int i = withoutArgs.indexOf(47);
        if (i <= -1) {
            throw new IllegalArgumentException("Invalid mime type: " + name);
        }
        this.type = withoutArgs.substring(0, i);
        this.subtype = withoutArgs.substring(i + 1);
        this.extension = extension != null ? extension : ((j = this.subtype.indexOf(43)) > -1 ? this.subtype.substring(j + 1) : this.subtype);
        this.strRepr = params == null || params.isEmpty() ? name : this.toString0();
    }

    public static MediaType of(String mediaType) {
        return switch (mediaType) {
            case ALL -> ALL_TYPE;
            case APPLICATION_FORM_URLENCODED -> APPLICATION_FORM_URLENCODED_TYPE;
            case APPLICATION_XHTML -> APPLICATION_XHTML_TYPE;
            case APPLICATION_XML -> APPLICATION_XML_TYPE;
            case APPLICATION_JSON -> APPLICATION_JSON_TYPE;
            case APPLICATION_JSON_FEED -> APPLICATION_JSON_FEED_TYPE;
            case APPLICATION_JSON_GITHUB -> APPLICATION_JSON_GITHUB_TYPE;
            case APPLICATION_JSON_PATCH -> APPLICATION_JSON_PATCH_TYPE;
            case APPLICATION_JSON_MERGE_PATCH -> APPLICATION_JSON_MERGE_PATCH_TYPE;
            case APPLICATION_JSON_PROBLEM -> APPLICATION_JSON_PROBLEM_TYPE;
            case APPLICATION_JSON_SCHEMA -> APPLICATION_JSON_SCHEMA_TYPE;
            case APPLICATION_YAML -> APPLICATION_YAML_TYPE;
            case APPLICATION_HAL_JSON -> APPLICATION_HAL_JSON_TYPE;
            case APPLICATION_HAL_XML -> APPLICATION_HAL_XML_TYPE;
            case APPLICATION_ATOM_XML -> APPLICATION_ATOM_XML_TYPE;
            case APPLICATION_VND_ERROR -> APPLICATION_VND_ERROR_TYPE;
            case APPLICATION_JSON_STREAM -> APPLICATION_JSON_STREAM_TYPE;
            case APPLICATION_OCTET_STREAM -> APPLICATION_OCTET_STREAM_TYPE;
            case APPLICATION_GRAPHQL -> APPLICATION_GRAPHQL_TYPE;
            case APPLICATION_PDF -> APPLICATION_PDF_TYPE;
            case APPLICATION_GPX_XML -> GPX_XML_TYPE;
            case APPLICATION_GZIP -> GZIP_TYPE;
            case APPLICATION_ZIP -> ZIP_TYPE;
            case MICROSOFT_EXCEL_OPEN_XML -> MICROSOFT_EXCEL_OPEN_XML_TYPE;
            case MICROSOFT_EXCEL -> MICROSOFT_EXCEL_TYPE;
            case OPEN_DOCUMENT_SPREADSHEET -> OPEN_DOCUMENT_SPREADSHEET_TYPE;
            case MICROSOFT_WORD_OPEN_XML -> MICROSOFT_WORD_OPEN_XML_TYPE;
            case MICROSOFT_WORD -> MICROSOFT_WORD_TYPE;
            case OPEN_DOCUMENT_TEXT -> OPEN_DOCUMENT_TEXT_TYPE;
            case MICROSOFT_POWERPOINT -> MICROSOFT_POWERPOINT_TYPE;
            case MICROSOFT_POWERPOINT_OPEN_XML -> MICROSOFT_POWERPOINT_OPEN_XML_TYPE;
            case OPEN_DOCUMENT_PRESENTATION -> OPEN_DOCUMENT_PRESENTATION_TYPE;
            case APPLICATION_YANG -> YANG_TYPE;
            case APPLICATION_CUE -> CUE_TYPE;
            case APPLICATION_TOML -> TOML_TYPE;
            case APPLICATION_RTF -> RTF_TYPE;
            case APPLICATION_ZLIB -> ZLIB_TYPE;
            case APPLICATION_ZSTD -> ZSTD_TYPE;
            case MULTIPART_FORM_DATA -> MULTIPART_FORM_DATA_TYPE;
            case TEXT_HTML -> TEXT_HTML_TYPE;
            case TEXT_CSV -> TEXT_CSV_TYPE;
            case TEXT_XML -> TEXT_XML_TYPE;
            case TEXT_JSON -> TEXT_JSON_TYPE;
            case TEXT_PLAIN -> TEXT_PLAIN_TYPE;
            case TEXT_EVENT_STREAM -> TEXT_EVENT_STREAM_TYPE;
            case TEXT_MARKDOWN -> TEXT_MARKDOWN_TYPE;
            case TEXT_CSS -> TEXT_CSS_TYPE;
            case TEXT_JAVASCRIPT -> TEXT_JAVASCRIPT_TYPE;
            case TEXT_ECMASCRIPT -> TEXT_ECMASCRIPT_TYPE;
            case IMAGE_APNG -> IMAGE_APNG_TYPE;
            case IMAGE_BMP -> IMAGE_BMP_TYPE;
            case IMAGE_X_ICON -> IMAGE_X_ICON_TYPE;
            case IMAGE_TIFF -> IMAGE_TIFF_TYPE;
            case IMAGE_AVIF -> IMAGE_AVIF_TYPE;
            case IMAGE_SVG -> IMAGE_SVG_TYPE;
            case IMAGE_XBM -> IMAGE_XBM_TYPE;
            case IMAGE_PNG -> IMAGE_PNG_TYPE;
            case IMAGE_JPEG -> IMAGE_JPEG_TYPE;
            case IMAGE_GIF -> IMAGE_GIF_TYPE;
            case IMAGE_WEBP -> IMAGE_WEBP_TYPE;
            case IMAGE_WMF -> IMAGE_WMF_TYPE;
            default -> new MediaType(mediaType);
        };
    }

    public boolean matches(@NonNull MediaType expectedContentType) {
        if (expectedContentType == null) {
            return false;
        }
        if (expectedContentType == this) {
            return true;
        }
        return this.matchesType(expectedContentType.getType()) && this.matchesSubtype(expectedContentType.getSubtype());
    }

    public boolean matchesSubtype(String matchSubtype) {
        return this.subtype.equals(WILDCARD) || this.subtype.equalsIgnoreCase(matchSubtype);
    }

    public boolean matchesType(String matchType) {
        return this.type.equals(WILDCARD) || this.type.equalsIgnoreCase(matchType);
    }

    public boolean matchesAllOrWildcardOrExtension(String matchExtension) {
        return this.extension.equalsIgnoreCase(MediaType.ALL_TYPE.extension) || this.extension.equals(WILDCARD) || this.matchesExtension(matchExtension);
    }

    public boolean matchesExtension(String matchExtension) {
        return this.extension.equalsIgnoreCase(matchExtension);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getExtension() {
        return this.extension;
    }

    public OptionalValues<String> getParameters() {
        return OptionalValues.of(String.class, this.parameters);
    }

    public @NonNull Map<CharSequence, String> getParametersMap() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getQuality() {
        return this.qualityNumberField.toString();
    }

    public BigDecimal getQualityAsNumber() {
        return this.qualityNumberField;
    }

    public String getVersion() {
        return this.parameters.getOrDefault(V_PARAMETER, null);
    }

    public Optional<Charset> getCharset() {
        String charset = this.parameters.get(CHARSET_PARAMETER);
        if (charset == null) {
            return Optional.empty();
        }
        return Optional.of(Charset.forName(charset));
    }

    @Override
    public int length() {
        return this.strRepr.length();
    }

    @Override
    public char charAt(int index) {
        return this.strRepr.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.strRepr.subSequence(start, end);
    }

    public boolean isTextBased() {
        boolean matches = textTypePatterns.stream().anyMatch(p -> p.matcher(this.name).matches());
        if (!matches) {
            matches = this.subtype.equalsIgnoreCase(EXTENSION_JSON) || this.subtype.equalsIgnoreCase(EXTENSION_XML) || this.subtype.equalsIgnoreCase("x-yaml") || this.subtype.equalsIgnoreCase("graphql") || this.subtype.equalsIgnoreCase("yang") || this.subtype.equalsIgnoreCase("toml") || this.subtype.equalsIgnoreCase("x-cue");
        }
        return matches;
    }

    public static boolean isTextBased(String contentType) {
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return false;
        }
        try {
            return MediaType.of(contentType).isTextBased();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Internal
    public void validate(Runnable r) {
        if (!this.valid) {
            r.run();
            this.valid = true;
        }
    }

    @Override
    public String toString() {
        return this.strRepr;
    }

    private String toString0() {
        if (this.parameters.isEmpty()) {
            return this.name;
        }
        StringBuilder sb = new StringBuilder(this.name);
        this.parameters.forEach((name, value) -> {
            sb.append(';');
            sb.append((CharSequence)name);
            sb.append('=');
            sb.append((String)value);
        });
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType mediaType = (MediaType)o;
        return this.lowerName.equals(mediaType.lowerName);
    }

    public int hashCode() {
        return this.lowerName.hashCode();
    }

    public static List<MediaType> orderedOf(CharSequence ... values) {
        return MediaType.orderedOf(Arrays.asList(values));
    }

    public static List<MediaType> orderedOf(List<? extends CharSequence> values) {
        String singleHeader;
        if (values == null) {
            return Collections.emptyList();
        }
        int headerCount = values.size();
        if (headerCount == 0) {
            return Collections.emptyList();
        }
        if (headerCount == 1 && (singleHeader = values.get(0).toString()).indexOf(44) == -1) {
            try {
                return List.of(MediaType.of(singleHeader));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>(values.size());
        for (CharSequence charSequence : values) {
            for (String token : StringUtils.splitOmitEmptyStrings((CharSequence)charSequence, (char)',')) {
                try {
                    mediaTypes.add(MediaType.of(token));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        mediaTypes.sort(MediaType::naturalSort);
        return Collections.unmodifiableList(mediaTypes);
    }

    private static int naturalSort(MediaType o1, MediaType o2) {
        boolean fullWildcard1 = o1.type.equals(WILDCARD);
        boolean fullWildcard2 = o2.type.equals(WILDCARD);
        if (fullWildcard1 && fullWildcard2) {
            return 0;
        }
        if (fullWildcard1) {
            return 1;
        }
        if (fullWildcard2) {
            return -1;
        }
        if (o2.subtype.equals(WILDCARD) && !o1.subtype.equals(WILDCARD)) {
            return -1;
        }
        if (o1.subtype.equals(WILDCARD) && !o2.subtype.equals(WILDCARD)) {
            return 1;
        }
        return o2.getQualityAsNumber().compareTo(o1.getQualityAsNumber());
    }

    public static MediaType of(CharSequence mediaType) {
        return MediaType.of(mediaType.toString());
    }

    public static MediaType[] of(CharSequence ... mediaType) {
        MediaType[] types = new MediaType[mediaType.length];
        for (int i = 0; i < mediaType.length; ++i) {
            types[i] = MediaType.of(mediaType[i].toString());
        }
        return types;
    }

    public static Optional<MediaType> fromType(Class<?> type) {
        Object[] value;
        Produces producesAnn = type.getAnnotation(Produces.class);
        if (producesAnn != null && ArrayUtils.isNotEmpty((Object[])(value = producesAnn.value()))) {
            return Optional.of(MediaType.of((String)value[0]));
        }
        return Optional.empty();
    }

    public static Optional<MediaType> forExtension(String extension) {
        String type;
        Map<String, String> extensions;
        if (StringUtils.isNotEmpty((CharSequence)extension) && (extensions = MediaType.getMediaTypeFileExtensions()) != null && (type = extensions.get(extension)) != null) {
            return Optional.of(new MediaType(type, extension));
        }
        return Optional.empty();
    }

    public static MediaType forFilename(String filename) {
        if (StringUtils.isNotEmpty((CharSequence)filename)) {
            return MediaType.forExtension(NameUtils.extension((String)filename)).orElse(TEXT_PLAIN_TYPE);
        }
        return TEXT_PLAIN_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> getMediaTypeFileExtensions() {
        Map<String, String> extensions = mediaTypeFileExtensions;
        if (extensions != null) return extensions;
        Class<MediaType> clazz = MediaType.class;
        synchronized (MediaType.class) {
            extensions = mediaTypeFileExtensions;
            if (extensions != null) return extensions;
            try {
                mediaTypeFileExtensions = extensions = MediaType.loadMimeTypes();
            }
            catch (Exception e) {
                mediaTypeFileExtensions = Collections.emptyMap();
            }
            return extensions;
        }
    }

    private static Map<String, String> loadMimeTypes() {
        LinkedHashMap<String, String> linkedHashMap;
        block11: {
            InputStream is = MediaType.class.getClassLoader().getResourceAsStream(MIME_TYPES_FILE_NAME);
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.US_ASCII));
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(100);
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty() || line.charAt(0) == '#') continue;
                    String formattedLine = line.trim().replaceAll("\\s{2,}", " ").replaceAll("\\s", "|");
                    String[] tokens = formattedLine.split("\\|");
                    for (int i = 1; i < tokens.length; ++i) {
                        String fileExtension = tokens[i].toLowerCase(Locale.ENGLISH);
                        result.put(fileExtension, tokens[0]);
                    }
                }
                linkedHashMap = result;
                if (is == null) break block11;
            }
            catch (Throwable reader) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            reader.addSuppressed(throwable);
                        }
                    }
                    throw reader;
                }
                catch (IOException ex) {
                    Logger logger = LoggerFactory.getLogger(MediaType.class);
                    if (logger.isWarnEnabled()) {
                        logger.warn("Failed to load mime types for file extension detection!");
                    }
                    return Collections.emptyMap();
                }
            }
            is.close();
        }
        return linkedHashMap;
    }

    static {
        FORM = APPLICATION_FORM_URLENCODED_TYPE = new MediaType(APPLICATION_FORM_URLENCODED);
        APPLICATION_XHTML_TYPE = new MediaType(APPLICATION_XHTML, "html");
        APPLICATION_XML_TYPE = new MediaType(APPLICATION_XML);
        APPLICATION_JSON_GITHUB_TYPE = new MediaType(APPLICATION_JSON_GITHUB);
        APPLICATION_JSON_FEED_TYPE = new MediaType(APPLICATION_JSON_FEED);
        APPLICATION_JSON_PATCH_TYPE = new MediaType(APPLICATION_JSON_PATCH);
        APPLICATION_JSON_MERGE_PATCH_TYPE = new MediaType(APPLICATION_JSON_MERGE_PATCH);
        APPLICATION_JSON_PROBLEM_TYPE = new MediaType(APPLICATION_JSON_PROBLEM);
        APPLICATION_JSON_SCHEMA_TYPE = new MediaType(APPLICATION_JSON_SCHEMA);
        APPLICATION_JSON_TYPE = new MediaType(APPLICATION_JSON);
        APPLICATION_YAML_TYPE = new MediaType(APPLICATION_YAML);
        MICROSOFT_EXCEL_OPEN_XML_TYPE = new MediaType(MICROSOFT_EXCEL_OPEN_XML, EXTENSION_XLSX);
        MICROSOFT_EXCEL_TYPE = new MediaType(MICROSOFT_EXCEL, EXTENSION_XLS);
        OPEN_DOCUMENT_SPREADSHEET_TYPE = new MediaType(OPEN_DOCUMENT_SPREADSHEET, EXTENSION_ODS);
        MICROSOFT_WORD_OPEN_XML_TYPE = new MediaType(MICROSOFT_WORD_OPEN_XML, EXTENSION_DOCX);
        MICROSOFT_WORD_TYPE = new MediaType(MICROSOFT_WORD, EXTENSION_DOC);
        OPEN_DOCUMENT_TEXT_TYPE = new MediaType(OPEN_DOCUMENT_TEXT, EXTENSION_ODT);
        MICROSOFT_POWERPOINT_OPEN_XML_TYPE = new MediaType(MICROSOFT_WORD_OPEN_XML, EXTENSION_PPTX);
        MICROSOFT_POWERPOINT_TYPE = new MediaType(MICROSOFT_POWERPOINT, EXTENSION_PPT);
        OPEN_DOCUMENT_PRESENTATION_TYPE = new MediaType(OPEN_DOCUMENT_PRESENTATION, EXTENSION_ODP);
        APPLICATION_HAL_JSON_TYPE = new MediaType(APPLICATION_HAL_JSON);
        APPLICATION_HAL_XML_TYPE = new MediaType(APPLICATION_HAL_XML);
        APPLICATION_ATOM_XML_TYPE = new MediaType(APPLICATION_ATOM_XML);
        APPLICATION_VND_ERROR_TYPE = new MediaType(APPLICATION_VND_ERROR);
        APPLICATION_JSON_STREAM_TYPE = new MediaType(APPLICATION_JSON_STREAM);
        APPLICATION_OCTET_STREAM_TYPE = new MediaType(APPLICATION_OCTET_STREAM);
        APPLICATION_GRAPHQL_TYPE = new MediaType(APPLICATION_GRAPHQL);
        GPX_XML_TYPE = new MediaType(APPLICATION_GPX_XML, EXTENSION_GPX);
        ZIP_TYPE = new MediaType(APPLICATION_ZIP);
        GZIP_TYPE = new MediaType(APPLICATION_GZIP);
        YANG_TYPE = new MediaType(APPLICATION_YANG);
        CUE_TYPE = new MediaType(APPLICATION_CUE);
        TOML_TYPE = new MediaType(APPLICATION_TOML);
        RTF_TYPE = new MediaType(APPLICATION_RTF);
        ZLIB_TYPE = new MediaType(APPLICATION_ZLIB);
        ZSTD_TYPE = new MediaType(APPLICATION_ZSTD);
        APPLICATION_PDF_TYPE = new MediaType(APPLICATION_PDF);
        TEXT_HTML_TYPE = new MediaType(TEXT_HTML);
        TEXT_CSV_TYPE = new MediaType(TEXT_CSV);
        TEXT_CSS_TYPE = new MediaType(TEXT_CSS);
        TEXT_XML_TYPE = new MediaType(TEXT_XML);
        TEXT_JSON_TYPE = new MediaType(TEXT_JSON);
        TEXT_JAVASCRIPT_TYPE = new MediaType(TEXT_JAVASCRIPT);
        TEXT_ECMASCRIPT_TYPE = new MediaType(TEXT_ECMASCRIPT);
        TEXT_PLAIN_TYPE = new MediaType(TEXT_PLAIN);
        TEXT_MARKDOWN_TYPE = new MediaType(TEXT_MARKDOWN);
        TEXT_EVENT_STREAM_TYPE = new MediaType(TEXT_EVENT_STREAM);
        IMAGE_APNG_TYPE = new MediaType(IMAGE_APNG);
        IMAGE_BMP_TYPE = new MediaType(IMAGE_BMP);
        IMAGE_X_ICON_TYPE = new MediaType(IMAGE_X_ICON);
        IMAGE_TIFF_TYPE = new MediaType(IMAGE_TIFF);
        IMAGE_AVIF_TYPE = new MediaType(IMAGE_AVIF);
        IMAGE_SVG_TYPE = new MediaType(IMAGE_SVG);
        IMAGE_XBM_TYPE = new MediaType(IMAGE_XBM);
        IMAGE_PNG_TYPE = new MediaType(IMAGE_PNG);
        IMAGE_JPEG_TYPE = new MediaType(IMAGE_JPEG);
        IMAGE_GIF_TYPE = new MediaType(IMAGE_GIF);
        IMAGE_WEBP_TYPE = new MediaType(IMAGE_WEBP);
        IMAGE_WMF_TYPE = new MediaType(IMAGE_WMF);
        ARGUMENT = Argument.of(MediaType.class);
        CONVERSION_CONTEXT = ImmutableArgumentConversionContext.of(ARGUMENT);
        textTypePatterns = new ArrayList<Pattern>(4);
        textTypePatterns.add(Pattern.compile("^text/.*$"));
        textTypePatterns.add(Pattern.compile("^.*\\+json$"));
        textTypePatterns.add(Pattern.compile("^.*\\+text$"));
        textTypePatterns.add(Pattern.compile("^.*\\+xml$"));
        textTypePatterns.add(Pattern.compile("^application/javascript$"));
    }
}

