/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.attr.MutableAttributeHolder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.util.HttpUtil;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

public interface HttpMessage<B>
extends MutableAttributeHolder {
    public @NonNull HttpHeaders getHeaders();

    public @NonNull MutableConvertibleValues<Object> getAttributes();

    public @NonNull Optional<B> getBody();

    default public Optional<MessageBodyWriter<B>> getBodyWriter() {
        return this.getAttribute(HttpAttributes.MESSAGE_BODY_WRITER, MessageBodyWriter.class);
    }

    default public @NonNull Charset getCharacterEncoding() {
        return HttpUtil.getCharset(this);
    }

    default public @NonNull HttpMessage<B> setAttribute(@NonNull CharSequence name, Object value) {
        return (HttpMessage)super.setAttribute(name, value);
    }

    default public <T> @NonNull Optional<T> getBody(@NonNull Argument<T> type) {
        return this.getBody(ConversionContext.of(type));
    }

    default public <T> @NonNull Optional<T> getBody(@NonNull ArgumentConversionContext<T> conversionContext) {
        ArgumentUtils.requireNonNull((String)"conversionContext", conversionContext);
        return this.getBody().flatMap(b -> ConversionService.SHARED.convert(b, conversionContext));
    }

    default public <T> @NonNull Optional<T> getBody(@NonNull Class<T> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        return this.getBody(Argument.of(type));
    }

    default public @NonNull Optional<Locale> getLocale() {
        return this.getHeaders().findFirst("Content-Language").map(Locale::new);
    }

    default public long getContentLength() {
        return this.getHeaders().contentLength().orElse(-1L);
    }

    default public @NonNull Optional<MediaType> getContentType() {
        return this.getHeaders().contentType();
    }
}

