/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.MutableHttpHeaders;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.jspecify.annotations.Nullable;

@Internal
public final class CaseInsensitiveMutableHttpHeaders
implements MutableHttpHeaders {
    private final boolean validate;
    private final TreeMap<String, List<String>> backing;
    private ConversionService conversionService;
    private static final long TOKEN_CHARS_HIGH;
    private static final long TOKEN_CHARS_LOW;

    public CaseInsensitiveMutableHttpHeaders(ConversionService conversionService) {
        this(true, Collections.emptyMap(), conversionService);
    }

    public CaseInsensitiveMutableHttpHeaders(boolean validate, ConversionService conversionService) {
        this(validate, Collections.emptyMap(), conversionService);
    }

    public CaseInsensitiveMutableHttpHeaders(Map<String, List<String>> defaults, ConversionService conversionService) {
        this(true, defaults, conversionService);
    }

    public CaseInsensitiveMutableHttpHeaders(boolean validate, Map<String, List<String>> defaults, ConversionService conversionService) {
        this.validate = validate;
        this.conversionService = conversionService;
        this.backing = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        defaults.forEach((key, value) -> value.forEach(v -> this.add((CharSequence)key, (CharSequence)v)));
    }

    public List<String> getAll(CharSequence name) {
        if (name == null) {
            return Collections.emptyList();
        }
        List<String> values = this.backing.get(name.toString());
        if (CollectionUtils.isEmpty(values)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(values);
    }

    public @Nullable String get(CharSequence name) {
        if (name == null) {
            return null;
        }
        List<String> strings = this.backing.get(name.toString());
        if (CollectionUtils.isEmpty(strings)) {
            return null;
        }
        return strings.get(0);
    }

    public Set<String> names() {
        return this.backing.keySet();
    }

    public Collection<List<String>> values() {
        return this.backing.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        String value = this.get(name);
        if (value != null) {
            if (conversionContext.getArgument().getType().isInstance(value)) {
                return Optional.of(value);
            }
            return this.conversionService.convert((Object)value, conversionContext);
        }
        return Optional.empty();
    }

    @Override
    public MutableHttpHeaders add(CharSequence header, CharSequence value) {
        this.validate(header, value);
        this.backing.computeIfAbsent(header.toString(), s -> new ArrayList(2)).add(value.toString());
        return this;
    }

    @Override
    public MutableHttpHeaders remove(CharSequence header) {
        if (header != null) {
            this.backing.remove(header.toString());
        }
        return this;
    }

    private void validate(CharSequence header, CharSequence value) {
        if (header == null) {
            throw new IllegalArgumentException("Header name cannot be null");
        }
        if (this.validate) {
            int index = CaseInsensitiveMutableHttpHeaders.validateCharSequenceToken(header);
            if (index != -1) {
                throw new IllegalArgumentException("A header name can only contain \"token\" characters, but found invalid character 0x" + Integer.toHexString(header.charAt(index)) + " at index " + index + " of header '" + String.valueOf(header) + "'.");
            }
            index = CaseInsensitiveMutableHttpHeaders.verifyValidHeaderValueCharSequence(value);
            if (index != -1) {
                throw new IllegalArgumentException("The header value for '" + String.valueOf(header) + "' contains prohibited character 0x" + Integer.toHexString(value.charAt(index)) + " at index " + index + ".");
            }
        }
    }

    private static int validateCharSequenceToken(CharSequence token) {
        int len = token.length();
        for (int i = 0; i < len; ++i) {
            byte value = (byte)token.charAt(i);
            if (BitSet128.contains(value, TOKEN_CHARS_HIGH, TOKEN_CHARS_LOW)) continue;
            return i;
        }
        return -1;
    }

    private static int verifyValidHeaderValueCharSequence(CharSequence value) {
        if (value.isEmpty()) {
            return -1;
        }
        char b = value.charAt(0);
        if (b < '!' || b == '\u007f') {
            return 0;
        }
        int length = value.length();
        for (int i = 1; i < length; ++i) {
            b = value.charAt(i);
            if ((b >= ' ' || b == '\t') && b != '\u007f') continue;
            return i;
        }
        return -1;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    static {
        BitSet128 tokenChars = new BitSet128().range('0', '9').range('a', 'z').range('A', 'Z').bits('-', '.', '_', '~').bits('!', '#', '$', '%', '&', '\'', '*', '+', '^', '`', '|');
        TOKEN_CHARS_HIGH = tokenChars.high();
        TOKEN_CHARS_LOW = tokenChars.low();
    }

    private static final class BitSet128 {
        private long high;
        private long low;

        private BitSet128() {
        }

        BitSet128 range(char fromInc, char toInc) {
            for (int bit = fromInc; bit <= toInc; ++bit) {
                if (bit < 64) {
                    this.low |= 1L << bit;
                    continue;
                }
                this.high |= 1L << bit - 64;
            }
            return this;
        }

        BitSet128 bits(char ... bits) {
            for (char bit : bits) {
                if (bit < '@') {
                    this.low |= 1L << bit;
                    continue;
                }
                this.high |= 1L << bit - 64;
            }
            return this;
        }

        long high() {
            return this.high;
        }

        long low() {
            return this.low;
        }

        static boolean contains(byte bit, long high, long low) {
            if (bit < 0) {
                return false;
            }
            if (bit < 64) {
                return 0L != (low & 1L << bit);
            }
            return 0L != (high & 1L << bit - 64);
        }
    }
}

