/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.context;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.propagation.ReactorPropagation;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.core.propagation.PropagatedContextElement;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerHttpRequestContext;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import reactor.util.context.ContextView;

public final class ServerRequestContext {
    @Deprecated
    public static final String KEY = "micronaut.http.server.request";

    private ServerRequestContext() {
    }

    public static void with(@Nullable HttpRequest<?> request, @NonNull Runnable runnable) {
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new ServerHttpRequestContext(request)).propagate();){
            runnable.run();
        }
    }

    public static Runnable instrument(@Nullable HttpRequest<?> request, @NonNull Runnable runnable) {
        return () -> ServerRequestContext.with(request, runnable);
    }

    public static <T> T with(@Nullable HttpRequest<?> request, @NonNull Supplier<T> supplier) {
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new ServerHttpRequestContext(request)).propagate();){
            T t = supplier.get();
            return t;
        }
    }

    public static <T> T with(@Nullable HttpRequest<?> request, @NonNull Callable<T> callable) throws Exception {
        try (PropagatedContext.Scope ignore = PropagatedContext.getOrEmpty().plus((PropagatedContextElement)new ServerHttpRequestContext(request)).propagate();){
            T t = callable.call();
            return t;
        }
    }

    public static <T> Optional<HttpRequest<T>> currentRequest() {
        return ServerHttpRequestContext.find();
    }

    @NonNull
    public static <T> Optional<HttpRequest<T>> currentRequest(@NonNull ContextView context) {
        return ReactorPropagation.findPropagatedContext((ContextView)context).flatMap(ctx -> ctx.find(ServerHttpRequestContext.class)).map(e -> e.httpRequest()).or(() -> context.getOrEmpty((Object)KEY));
    }
}

