/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.cachecontrol;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.cachecontrol.ResponseDirective;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public record CacheControl(@NonNull List<CacheControlResponseDirective> responseDirectives) {
    private static final String EQUAL = "=";

    @Override
    public String toString() {
        return String.join((CharSequence)", ", this.responseDirectives.stream().map(dir -> dir.seconds() != null ? String.join((CharSequence)EQUAL, dir.directive().toString(), String.valueOf(dir.seconds())) : dir.directive().toString()).toList());
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<CacheControlResponseDirective> responseDirectives = new ArrayList<CacheControlResponseDirective>();

        private Builder() {
        }

        @NonNull
        public Builder proxyRevalidate() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.PROXY_REVALIDATE));
            return this;
        }

        @NonNull
        public Builder mustRevalidate() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.MUST_REVALIDATE));
            return this;
        }

        @NonNull
        public Builder sMaxAge(@NonNull Long sMaxAge) {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.S_MAXAGE, sMaxAge));
            return this;
        }

        @NonNull
        public Builder sMaxAge(@NonNull Duration sMaxAge) {
            return this.sMaxAge(sMaxAge.getSeconds());
        }

        @NonNull
        public Builder maxAge(@NonNull Long maxAge) {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.MAX_AGE, maxAge));
            return this;
        }

        @NonNull
        public Builder maxAge(@NonNull Duration maxAge) {
            return this.maxAge(maxAge.getSeconds());
        }

        @NonNull
        public Builder inmutable() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.IMMUTABLE));
            return this;
        }

        @NonNull
        public Builder publicDirective() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.PUBLIC));
            return this;
        }

        @NonNull
        public Builder privateDirective() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.PRIVATE));
            return this;
        }

        @NonNull
        public Builder noStore() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.NO_STORE));
            return this;
        }

        @NonNull
        public Builder noCache() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.NO_CACHE));
            return this;
        }

        @NonNull
        public Builder mustUnderstand() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.MUST_UNDERSTAND));
            return this;
        }

        @NonNull
        public Builder noTransform() {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.NO_TRANSFORM));
            return this;
        }

        @NonNull
        public Builder staleWhileRevalidate(@NonNull Duration staleWhileRevalidate) {
            return this.staleWhileRevalidate(staleWhileRevalidate.getSeconds());
        }

        @NonNull
        public Builder staleWhileRevalidate(@NonNull Long seconds) {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.STALE_WHILE_REVALIDATE, seconds));
            return this;
        }

        @NonNull
        public Builder staleIfError(@NonNull Duration staleIfError) {
            return this.staleIfError(staleIfError.getSeconds());
        }

        @NonNull
        public Builder staleIfError(@NonNull Long seconds) {
            this.responseDirectives.add(new CacheControlResponseDirective(ResponseDirective.STALE_IF_ERROR, seconds));
            return this;
        }

        @NonNull
        public CacheControl build() {
            return new CacheControl(this.responseDirectives);
        }
    }

    record CacheControlResponseDirective(@NonNull ResponseDirective directive, @Nullable Long seconds) {
        CacheControlResponseDirective(@NonNull ResponseDirective directive) {
            this(directive, null);
        }
    }
}

