/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.ByteBufferBodyAdapter;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ReactiveByteBufferByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;

@Internal
public abstract class ConcatenatingSubscriber
implements BufferConsumer.Upstream,
CoreSubscriber<ByteBody>,
BufferConsumer {
    private long forwarded;
    private long consumed;
    private Subscription subscription;
    private boolean cancelled;
    private volatile boolean disregardBackpressure;
    private boolean first = true;
    private BufferConsumer.Upstream currentComponent;
    private boolean start = false;
    private boolean delayedSubscriberCompletion = false;
    private boolean currentComponentDone = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSubscribe(Subscription s) {
        boolean start;
        boolean cancelled;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            this.subscription = s;
            cancelled = this.cancelled;
            start = this.start;
        }
        if (cancelled) {
            s.cancel();
        } else if (start) {
            s.request(1L);
        }
    }

    protected long emitLeadingSeparator(boolean first) {
        return 0L;
    }

    protected long emitFinalSeparator(boolean first) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onComplete() {
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            if (this.currentComponent != null) {
                this.delayedSubscriberCompletion = true;
                return;
            }
        }
        long emitted = this.emitFinalSeparator(this.first);
        if (emitted != 0L) {
            ConcatenatingSubscriber concatenatingSubscriber2 = this;
            synchronized (concatenatingSubscriber2) {
                this.forwarded += emitted;
            }
        }
        this.forwardComplete();
    }

    public final void onError(Throwable t) {
        this.forwardError(t);
    }

    @Nullable
    protected abstract BufferConsumer.Upstream forward(ByteBody var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onForward(long n) {
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            this.forwarded += n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onNext(ByteBody body) {
        long preAcknowledged;
        this.onForward(this.emitLeadingSeparator(this.first));
        this.first = false;
        BufferConsumer.Upstream component = this.forward(body);
        if (component == null) {
            return;
        }
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            preAcknowledged = this.consumed - this.forwarded;
            this.currentComponent = component;
        }
        component.start();
        if (this.disregardBackpressure) {
            component.disregardBackpressure();
        } else if (preAcknowledged > 0L) {
            component.onBytesConsumed(preAcknowledged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        Subscription initialDemand;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            initialDemand = this.subscription;
            this.start = true;
        }
        if (initialDemand != null) {
            initialDemand.request(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onBytesConsumed(long bytesConsumed) {
        boolean requestNewComponent;
        BufferConsumer.Upstream currentComponent;
        long delta;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            long newConsumed = this.consumed + bytesConsumed;
            if (newConsumed < this.consumed) {
                newConsumed = Long.MAX_VALUE;
            }
            delta = newConsumed - this.consumed;
            this.consumed = newConsumed;
            currentComponent = this.currentComponent;
            requestNewComponent = currentComponent == null && this.currentComponentDone && newConsumed >= this.forwarded;
        }
        if (currentComponent != null && delta > 0L) {
            currentComponent.onBytesConsumed(bytesConsumed);
        } else if (requestNewComponent) {
            this.subscription.request(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void allowDiscard() {
        Subscription subscription;
        BufferConsumer.Upstream component;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            component = this.currentComponent;
            subscription = this.subscription;
            this.cancelled = true;
        }
        if (subscription != null) {
            subscription.cancel();
        }
        if (component != null) {
            component.allowDiscard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void disregardBackpressure() {
        BufferConsumer.Upstream component;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            component = this.currentComponent;
            this.disregardBackpressure = true;
        }
        if (component != null) {
            component.disregardBackpressure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void complete() {
        boolean requestNextComponent;
        boolean delayedSubscriberCompletion;
        ConcatenatingSubscriber concatenatingSubscriber = this;
        synchronized (concatenatingSubscriber) {
            this.currentComponent = null;
            delayedSubscriberCompletion = this.delayedSubscriberCompletion;
            requestNextComponent = !delayedSubscriberCompletion && (this.disregardBackpressure || this.consumed >= this.forwarded);
            this.currentComponentDone = !requestNextComponent;
        }
        if (delayedSubscriberCompletion) {
            this.onComplete();
        } else if (requestNextComponent) {
            this.subscription.request(1L);
        }
    }

    @Override
    public final void error(Throwable e) {
        this.subscription.cancel();
        this.forwardError(e);
    }

    protected abstract void forwardComplete();

    protected abstract void forwardError(Throwable var1);

    public static final class JsonByteBufferConcatenatingSubscriber
    extends ByteBufferConcatenatingSubscriber {
        private static final ByteBuffer START_ARRAY = ByteBuffer.wrap("[".getBytes(StandardCharsets.UTF_8));
        private static final ByteBuffer END_ARRAY = ByteBuffer.wrap("]".getBytes(StandardCharsets.UTF_8));
        private static final ByteBuffer SEPARATOR = ByteBuffer.wrap(",".getBytes(StandardCharsets.UTF_8));
        private static final ByteBuffer EMPTY_ARRAY = ByteBuffer.wrap("[]".getBytes(StandardCharsets.UTF_8));

        private JsonByteBufferConcatenatingSubscriber() {
        }

        public static CloseableByteBody concatenateJson(Publisher<ByteBody> publisher) {
            JsonByteBufferConcatenatingSubscriber subscriber = new JsonByteBufferConcatenatingSubscriber();
            publisher.subscribe((Subscriber)subscriber);
            return new ReactiveByteBufferByteBody(subscriber.sharedBuffer);
        }

        @Override
        protected long emitLeadingSeparator(boolean first) {
            this.sharedBuffer.add((first ? START_ARRAY : SEPARATOR).asReadOnlyBuffer());
            return 1L;
        }

        @Override
        protected long emitFinalSeparator(boolean first) {
            this.sharedBuffer.add((first ? EMPTY_ARRAY : END_ARRAY).asReadOnlyBuffer());
            return first ? 2L : 1L;
        }
    }

    public static class ByteBufferConcatenatingSubscriber
    extends ConcatenatingSubscriber
    implements ReactiveByteBufferByteBody.ByteBufferConsumer {
        final ReactiveByteBufferByteBody.SharedBuffer sharedBuffer = new ReactiveByteBufferByteBody.SharedBuffer(BodySizeLimits.UNLIMITED, this);

        private ByteBufferConcatenatingSubscriber() {
        }

        public static CloseableByteBody concatenate(Publisher<ByteBody> publisher) {
            ByteBufferConcatenatingSubscriber subscriber = new ByteBufferConcatenatingSubscriber();
            publisher.subscribe((Subscriber)subscriber);
            return new ReactiveByteBufferByteBody(subscriber.sharedBuffer);
        }

        @Override
        protected BufferConsumer.Upstream forward(ByteBody body) {
            return ByteBufferBodyAdapter.adapt((Publisher<ByteBuffer>)Flux.from(body.toByteArrayPublisher()).map(ByteBuffer::wrap)).primary(this);
        }

        @Override
        public void add(@NonNull ByteBuffer buffer) {
            int n = buffer.remaining();
            this.onForward(n);
            this.sharedBuffer.add(buffer);
        }

        @Override
        protected void forwardComplete() {
            this.sharedBuffer.complete();
        }

        @Override
        protected void forwardError(Throwable t) {
            this.sharedBuffer.error(t);
        }
    }
}

