/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body.stream;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.InternalByteBody;
import io.micronaut.http.body.stream.InputStreamByteBody;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class AvailableByteArrayBody
implements CloseableAvailableByteBody,
InternalByteBody {
    private final ByteBufferFactory<?, ?> bufferFactory;
    private byte[] array;

    private AvailableByteArrayBody(ByteBufferFactory<?, ?> bufferFactory, byte[] array) {
        this.bufferFactory = bufferFactory;
        this.array = array;
    }

    @NonNull
    public static AvailableByteArrayBody create(@NonNull ByteBufferFactory<?, ?> bufferFactory, byte @NonNull [] array) {
        ArgumentUtils.requireNonNull((String)"bufferFactory", bufferFactory);
        ArgumentUtils.requireNonNull((String)"array", (Object)array);
        return new AvailableByteArrayBody(bufferFactory, array);
    }

    @Override
    @NonNull
    public CloseableAvailableByteBody split() {
        if (this.array == null) {
            InputStreamByteBody.failClaim();
        }
        return new AvailableByteArrayBody(this.bufferFactory, this.array);
    }

    @Override
    @NonNull
    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.array);
    }

    @Override
    public long length() {
        if (this.array == null) {
            InputStreamByteBody.failClaim();
        }
        return this.array.length;
    }

    @Override
    public byte @NonNull [] toByteArray() {
        byte[] a = this.array;
        if (a == null) {
            InputStreamByteBody.failClaim();
        }
        this.array = null;
        return a;
    }

    @Override
    @NonNull
    public ByteBuffer<?> toByteBuffer() {
        return this.bufferFactory.wrap(this.toByteArray());
    }

    @Override
    public void close() {
        this.array = null;
    }

    @Override
    @NonNull
    public ExecutionFlow<? extends CloseableAvailableByteBody> bufferFlow() {
        return ExecutionFlow.just((Object)new AvailableByteArrayBody(this.bufferFactory, this.toByteArray()));
    }
}

