/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.bind.binders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.PendingRequestBindingResult;
import io.micronaut.http.bind.binders.PostponedRequestArgumentBinder;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.bind.binders.UnmatchedRequestArgumentBinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
public final class DefaultUnmatchedRequestArgumentBinder<T>
implements PostponedRequestArgumentBinder<T>,
UnmatchedRequestArgumentBinder {
    private final List<RequestArgumentBinder<Object>> internalPreUnmatchedArgumentBinders;
    private final List<RequestArgumentBinder<Object>> unmatchedArgumentBinders;
    private final List<RequestArgumentBinder<Object>> internalPostUnmatchedArgumentBinders;

    public DefaultUnmatchedRequestArgumentBinder(List<RequestArgumentBinder<Object>> internalPreUnmatchedArgumentBinders, List<RequestArgumentBinder<Object>> unmatchedArgumentBinders, List<RequestArgumentBinder<Object>> internalPostUnmatchedArgumentBinders) {
        this.internalPreUnmatchedArgumentBinders = internalPreUnmatchedArgumentBinders;
        this.unmatchedArgumentBinders = unmatchedArgumentBinders;
        this.internalPostUnmatchedArgumentBinders = internalPostUnmatchedArgumentBinders;
    }

    private Stream<RequestArgumentBinder<Object>> stream() {
        return Stream.concat(this.internalPreUnmatchedArgumentBinders.stream(), Stream.concat(this.unmatchedArgumentBinders.stream(), this.internalPostUnmatchedArgumentBinders.stream()));
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> request) {
        final ArrayList<PendingRequestBindingResult> pending = new ArrayList<PendingRequestBindingResult>();
        final ArrayList errors = new ArrayList();
        boolean allUnsatisfied = true;
        for (RequestArgumentBinder binder2 : this.stream().filter(binder -> !(binder instanceof PostponedRequestArgumentBinder)).toList()) {
            ArgumentBinder.BindingResult result = binder2.bind(context, request);
            if (result.isPresentAndSatisfied()) {
                return result;
            }
            if (result instanceof PendingRequestBindingResult) {
                PendingRequestBindingResult pendingRequestBindingResult = (PendingRequestBindingResult)result;
                pending.add(pendingRequestBindingResult);
                allUnsatisfied = false;
                continue;
            }
            if (result == ArgumentBinder.BindingResult.UNSATISFIED) continue;
            errors.addAll(result.getConversionErrors());
            allUnsatisfied = false;
        }
        if (allUnsatisfied) {
            return ArgumentBinder.BindingResult.unsatisfied();
        }
        return new PendingRequestBindingResult<T>(){

            @Override
            public boolean isPending() {
                return pending.stream().allMatch(PendingRequestBindingResult::isPending);
            }

            public Optional<T> getValue() {
                return pending.stream().filter(r -> !r.isPending()).findFirst().flatMap((? super T r) -> r.getValue());
            }

            public List<ConversionError> getConversionErrors() {
                return Stream.concat(errors.stream(), pending.stream().flatMap((? super T r) -> r.getConversionErrors().stream())).toList();
            }
        };
    }

    @Override
    public ArgumentBinder.BindingResult<T> bindPostponed(ArgumentConversionContext<T> context, HttpRequest<?> request) {
        ArgumentBinder.BindingResult lastWithError = null;
        for (RequestArgumentBinder binder2 : this.stream().filter(binder -> binder instanceof PostponedRequestArgumentBinder).toList()) {
            ArgumentBinder.BindingResult result = binder2.bind(context, request);
            if (result.getValue().isPresent()) {
                return result;
            }
            if (result.getConversionErrors().isEmpty()) continue;
            lastWithError = result;
        }
        return lastWithError == null ? ArgumentBinder.BindingResult.unsatisfied() : lastWithError;
    }
}

