/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.ssl;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.ssl.AbstractCertificateFileConfig;
import io.micronaut.http.ssl.CertificateProvider;
import io.micronaut.http.ssl.FileCertificateProvider;
import java.io.InputStream;
import java.security.KeyStore;
import org.reactivestreams.Publisher;

@EachBean(value=Config.class)
@BootstrapContextCompatible
public final class ResourceCertificateProvider
implements CertificateProvider {
    private final String name;
    @NonNull
    private final KeyStore ks;

    ResourceCertificateProvider(@NonNull Config config, @NonNull ResourceResolver resourceLoader) throws Exception {
        byte[] bytes;
        this.name = config.name;
        try (InputStream stream = (InputStream)resourceLoader.getResourceAsStream(config.getResource()).orElseThrow(() -> new ConfigurationException("Resource unavailable: " + config.getResource()));){
            bytes = stream.readAllBytes();
        }
        this.ks = FileCertificateProvider.load(config, bytes, null);
    }

    @Override
    @NonNull
    public @NonNull Publisher<@NonNull KeyStore> getKeyStore() {
        return Publishers.just((Object)this.ks);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @EachProperty(value="micronaut.certificate.resource")
    @BootstrapContextCompatible
    public static final class Config
    extends AbstractCertificateFileConfig {
        private String resource;

        public Config(@Parameter @NonNull String name) {
            super(name);
        }

        @NonNull
        public String getResource() {
            return this.resource;
        }

        public void setResource(@NonNull String resource) {
            this.resource = resource;
        }
    }
}

