/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.core.io.buffer.ReadBufferFactory;
import io.micronaut.core.util.functional.ThrowingConsumer;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.body.AbstractBodyAdapter;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ReactiveByteBufferByteBody;
import io.micronaut.http.body.stream.AvailableByteArrayBody;
import io.micronaut.http.body.stream.BaseSharedBuffer;
import io.micronaut.http.body.stream.BaseStreamingByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.OptionalLong;
import org.reactivestreams.Publisher;

public class ByteBodyFactory {
    private final ByteBufferFactory<?, ?> byteBufferFactory;
    private final ReadBufferFactory readBufferFactory;

    @Internal
    protected ByteBodyFactory(@NonNull ByteBufferFactory<?, ?> byteBufferFactory, ReadBufferFactory readBufferFactory) {
        this.byteBufferFactory = byteBufferFactory;
        this.readBufferFactory = readBufferFactory;
    }

    @NonNull
    public static ByteBodyFactory createDefault(@NonNull ByteBufferFactory<?, ?> byteBufferFactory) {
        return new ByteBodyFactory(byteBufferFactory, ReadBufferFactory.getJdkFactory());
    }

    @NonNull
    @Deprecated
    public final ByteBufferFactory<?, ?> byteBufferFactory() {
        return this.byteBufferFactory;
    }

    @NonNull
    public ReadBufferFactory readBufferFactory() {
        return this.readBufferFactory;
    }

    @NonNull
    public CloseableAvailableByteBody adapt(@NonNull ByteBuffer<?> buffer) {
        return this.adapt(this.readBufferFactory.adapt(buffer));
    }

    @NonNull
    public CloseableAvailableByteBody adapt(byte @NonNull [] array) {
        return this.adapt(this.readBufferFactory().adapt(array));
    }

    @NonNull
    public CloseableAvailableByteBody adapt(@NonNull ReadBuffer readBuffer) {
        return AvailableByteArrayBody.create(readBuffer);
    }

    @NonNull
    public <T extends Throwable> CloseableAvailableByteBody buffer(@NonNull ThrowingConsumer<? super OutputStream, T> writer) throws T {
        return this.adapt(this.readBufferFactory().buffer(writer));
    }

    @NonNull
    public CloseableAvailableByteBody createEmpty() {
        return this.adapt(this.readBufferFactory().createEmpty());
    }

    @NonNull
    public CloseableAvailableByteBody copyOf(@NonNull CharSequence cs, @NonNull Charset charset) {
        return this.adapt(this.readBufferFactory().copyOf(cs, charset));
    }

    @NonNull
    @Blocking
    public CloseableAvailableByteBody copyOf(@NonNull InputStream stream) throws IOException {
        return this.adapt(this.readBufferFactory().copyOf(stream));
    }

    @Internal
    @NonNull
    public StreamingBody createStreamingBody(@NonNull BodySizeLimits limits, @NonNull BufferConsumer.Upstream upstream) {
        ReactiveByteBufferByteBody.SharedBuffer sb = new ReactiveByteBufferByteBody.SharedBuffer(this.readBufferFactory(), limits, upstream);
        return new StreamingBody(sb, new ReactiveByteBufferByteBody(sb));
    }

    @Internal
    protected AbstractBodyAdapter createBodyAdapter(@NonNull Publisher<ReadBuffer> publisher, @Nullable Runnable onDiscard) {
        return new AbstractBodyAdapter(publisher, onDiscard);
    }

    @NonNull
    public CloseableByteBody adapt(@NonNull Publisher<ReadBuffer> publisher) {
        return this.adapt(publisher, BodySizeLimits.UNLIMITED, null, null);
    }

    @NonNull
    public CloseableByteBody adapt(@NonNull Publisher<ReadBuffer> publisher, @NonNull BodySizeLimits sizeLimits, @Nullable HttpHeaders headersForLength, @Nullable Runnable onDiscard) {
        AbstractBodyAdapter adapter = this.createBodyAdapter(publisher, onDiscard);
        StreamingBody sb = this.createStreamingBody(sizeLimits, adapter);
        adapter.setSharedBuffer(sb.sharedBuffer);
        if (headersForLength != null) {
            sb.sharedBuffer.setExpectedLengthFrom((String)headersForLength.get("Content-Length"));
        }
        return sb.rootBody;
    }

    @NonNull
    public CloseableByteBody adapt(@NonNull Publisher<ReadBuffer> publisher, @NonNull OptionalLong contentLength) {
        AbstractBodyAdapter adapter = this.createBodyAdapter(publisher, null);
        StreamingBody sb = this.createStreamingBody(BodySizeLimits.UNLIMITED, adapter);
        adapter.setSharedBuffer(sb.sharedBuffer);
        contentLength.ifPresent(sb.sharedBuffer::setExpectedLength);
        return sb.rootBody;
    }

    @Internal
    public BaseStreamingByteBody<?> toStreaming(@NonNull ByteBody body) {
        if (body instanceof BaseStreamingByteBody) {
            BaseStreamingByteBody bsbb = (BaseStreamingByteBody)body;
            return bsbb;
        }
        AbstractBodyAdapter adapter = this.createBodyAdapter(body.toReadBufferPublisher(), null);
        StreamingBody sb = this.createStreamingBody(BodySizeLimits.UNLIMITED, adapter);
        adapter.setSharedBuffer(sb.sharedBuffer);
        body.expectedLength().ifPresent(sb.sharedBuffer::setExpectedLength);
        return sb.rootBody;
    }

    @Internal
    public record StreamingBody(BaseSharedBuffer sharedBuffer, BaseStreamingByteBody<?> rootBody) {
    }
}

