/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.util.locale;

import io.micronaut.context.annotation.Primary;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.util.locale.HttpAbstractLocaleResolver;
import io.micronaut.http.server.util.locale.HttpLocaleResolutionConfiguration;
import io.micronaut.http.server.util.locale.HttpLocaleResolver;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

@Singleton
@Primary
public class CompositeHttpLocaleResolver
extends HttpAbstractLocaleResolver {
    private final HttpLocaleResolver[] localeResolvers;

    public CompositeHttpLocaleResolver(HttpLocaleResolver[] localeResolvers, HttpLocaleResolutionConfiguration httpLocaleResolutionConfiguration) {
        super(httpLocaleResolutionConfiguration);
        this.localeResolvers = localeResolvers;
    }

    public @NonNull Optional<Locale> resolve(@NonNull HttpRequest<?> request) {
        return Arrays.stream(this.localeResolvers).map(resolver -> resolver.resolve(request)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }
}

