/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ErrorExceptionHandler;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

@Singleton
@Produces
public class ConversionErrorHandler
extends ErrorExceptionHandler<ConversionErrorException> {
    public ConversionErrorHandler(ErrorResponseProcessor<?> responseProcessor) {
        super(responseProcessor);
    }

    @Override
    protected @NonNull Error error(final ConversionErrorException exception) {
        return new Error(){

            @Override
            public Optional<String> getPath() {
                return Optional.of("/" + exception.getArgument().getName());
            }

            @Override
            public String getMessage() {
                return exception.getMessage();
            }
        };
    }
}

