/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.websocket;

import io.micronaut.context.BeanContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.processor.BeanDefinitionProcessor;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.web.router.DefaultRouteBuilder;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.UriRoute;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.annotation.OnOpen;
import io.micronaut.websocket.annotation.ServerWebSocket;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.Set;

@Singleton
@Internal
@Requires(classes={ServerWebSocket.class, WebSocketBeanRegistry.class})
public class ServerWebSocketProcessor
extends DefaultRouteBuilder
implements BeanDefinitionProcessor<ServerWebSocket> {
    private Set<Class<?>> mappedWebSockets = new HashSet(4);

    ServerWebSocketProcessor(ExecutionHandleLocator executionHandleLocator, RouteBuilder.UriNamingStrategy uriNamingStrategy, ConversionService conversionService) {
        super(executionHandleLocator, uriNamingStrategy, conversionService);
    }

    public void process(BeanDefinition<?> beanDefinition, BeanContext beanContext) {
        Class beanType = beanDefinition.getBeanType();
        if (this.mappedWebSockets.contains(beanType)) {
            return;
        }
        for (ExecutableMethod method : beanDefinition.getExecutableMethods()) {
            if (!method.isAnnotationPresent(OnMessage.class) && !method.isAnnotationPresent(OnOpen.class)) continue;
            this.mappedWebSockets.add(beanType);
            String uri = beanDefinition.stringValue(ServerWebSocket.class).orElse("/ws");
            UriRoute route = this.GET(uri, method);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Created WebSocket: {}", (Object)route);
        }
    }
}

