/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.util.locale;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.util.locale.HttpAbstractLocaleResolver;
import io.micronaut.http.server.util.locale.HttpLocaleResolutionConfiguration;
import jakarta.inject.Singleton;
import java.util.Locale;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

@Singleton
@Requires(property="micronaut.server.locale-resolution.cookie-name")
public class CookieLocaleResolver
extends HttpAbstractLocaleResolver {
    private final String cookieName;

    public CookieLocaleResolver(HttpLocaleResolutionConfiguration httpLocaleResolutionConfiguration) {
        super(httpLocaleResolutionConfiguration);
        this.cookieName = httpLocaleResolutionConfiguration.getCookieName().orElseThrow(() -> new IllegalArgumentException("The locale cookie name must be set"));
    }

    public @NonNull Optional<Locale> resolve(@NonNull HttpRequest<?> request) {
        return request.getCookies().get((CharSequence)this.cookieName, Locale.class);
    }
}

