/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions.response;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.exceptions.response.DefaultErrorContext;
import io.micronaut.http.server.exceptions.response.Error;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ErrorContext {
    public @NonNull HttpRequest<?> getRequest();

    public @NonNull Optional<Throwable> getRootCause();

    public @NonNull List<Error> getErrors();

    default public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    public static @NonNull Builder builder(@NonNull HttpRequest<?> request) {
        return DefaultErrorContext.builder(request);
    }

    public static interface Builder {
        public @NonNull Builder cause(@Nullable Throwable var1);

        public @NonNull Builder errorMessage(@NonNull String var1);

        public @NonNull Builder error(@NonNull Error var1);

        public @NonNull Builder errorMessages(@NonNull List<String> var1);

        public @NonNull Builder errors(@NonNull List<Error> var1);

        public @NonNull ErrorContext build();
    }
}

