/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions.response;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Internal
final class DefaultErrorContext
implements ErrorContext {
    private final HttpRequest<?> request;
    private final Throwable cause;
    private final List<Error> jsonErrors;

    private DefaultErrorContext(@NonNull HttpRequest<?> request, @Nullable Throwable cause, @NonNull List<Error> jsonErrors) {
        this.request = request;
        this.cause = cause;
        this.jsonErrors = jsonErrors;
    }

    @Override
    public @NonNull HttpRequest<?> getRequest() {
        return this.request;
    }

    @Override
    public @NonNull Optional<Throwable> getRootCause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public @NonNull List<Error> getErrors() {
        return this.jsonErrors;
    }

    public static Builder builder(@NonNull HttpRequest<?> request) {
        return new Builder(request);
    }

    private static final class Builder
    implements ErrorContext.Builder {
        private final HttpRequest<?> request;
        private Throwable cause;
        private final List<Error> jsonErrors = new ArrayList<Error>();

        private Builder(@NonNull HttpRequest<?> request) {
            this.request = request;
        }

        @Override
        public @NonNull Builder cause(@Nullable Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public @NonNull Builder errorMessage(@NonNull String message) {
            this.jsonErrors.add(() -> message);
            return this;
        }

        @Override
        public @NonNull Builder error(@NonNull Error error) {
            this.jsonErrors.add(error);
            return this;
        }

        @Override
        public @NonNull Builder errorMessages(@NonNull List<String> errors) {
            for (String error : errors) {
                this.errorMessage(error);
            }
            return this;
        }

        @Override
        public @NonNull Builder errors(@NonNull List<Error> errors) {
            this.jsonErrors.addAll(errors);
            return this;
        }

        @Override
        public @NonNull ErrorContext build() {
            return new DefaultErrorContext(this.request, this.cause, this.jsonErrors);
        }
    }
}

