/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.core.bind.exceptions.UnsatisfiedArgumentException;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ErrorExceptionHandler;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.jspecify.annotations.NonNull;

@Singleton
@Produces
public class UnsatisfiedArgumentHandler
extends ErrorExceptionHandler<UnsatisfiedArgumentException> {
    public UnsatisfiedArgumentHandler(ErrorResponseProcessor<?> responseProcessor) {
        super(responseProcessor);
    }

    @Override
    protected @NonNull Error error(final UnsatisfiedArgumentException exception) {
        return new Error(){

            @Override
            public String getMessage() {
                return exception.getMessage();
            }

            @Override
            public Optional<String> getPath() {
                return Optional.of("/" + exception.getArgument().getName());
            }
        };
    }
}

