/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.binding;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.propagation.MutablePropagatedContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.filter.FilterArgumentBinderPredicate;
import io.micronaut.web.router.RouteAttributes;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.RouteMatch;
import jakarta.inject.Singleton;

@Singleton
@Internal
final class RouteInfoArgumentBinder
implements TypedRequestArgumentBinder<RouteInfo<?>>,
FilterArgumentBinderPredicate {
    RouteInfoArgumentBinder() {
    }

    public Argument<RouteInfo<?>> argumentType() {
        return Argument.of(RouteInfo.class);
    }

    public ArgumentBinder.BindingResult<RouteInfo<?>> bind(ArgumentConversionContext<RouteInfo<?>> context, HttpRequest<?> source) {
        return () -> RouteAttributes.getRouteInfo((HttpRequest)source).or(() -> RouteAttributes.getRouteMatch((HttpRequest)source).map(RouteMatch::getRouteInfo));
    }

    public boolean test(Argument<?> argument, MutablePropagatedContext mutablePropagatedContext, HttpRequest<?> request, @Nullable HttpResponse<?> response, @Nullable Throwable failure) {
        return argument.isNullable() || RouteAttributes.getRouteMatch(request).isPresent() || RouteAttributes.getRouteInfo(request).isPresent();
    }
}

