/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import io.micronaut.http.HttpStatus;
import io.micronaut.http.exceptions.HttpStatusException;
import java.util.Collection;

public final class NotAcceptableException
extends HttpStatusException {
    private final Collection<String> acceptedTypes;
    private final Collection<String> produceableContentTypes;

    public NotAcceptableException(Collection<String> acceptedTypes, Collection<String> produceableContentTypes) {
        super(HttpStatus.NOT_ACCEPTABLE, "Specified Accept Types " + String.valueOf(acceptedTypes) + " not supported. Supported types: " + String.valueOf(produceableContentTypes));
        this.acceptedTypes = acceptedTypes;
        this.produceableContentTypes = produceableContentTypes;
    }

    public Collection<String> getAcceptedTypes() {
        return this.acceptedTypes;
    }

    public Collection<String> getProduceableContentTypes() {
        return this.produceableContentTypes;
    }
}

