/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.textplain;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TxtPlainBooleanTest {
    public static final String SPEC_NAME = "TxtPlainBooleanTest";
    private static final HttpResponseAssertion ASSERTION = HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("true").equals()).assertResponse(response -> {
        Assertions.assertTrue((boolean)response.getContentType().isPresent());
        Assertions.assertEquals((Object)MediaType.TEXT_PLAIN_TYPE, response.getContentType().get());
    }).build();

    @Test
    void txtBoolean() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/txt/boolean").accept(new CharSequence[]{"text/plain"}), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)ASSERTION));
    }

    @Test
    void txtBooleanMono() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/txt/boolean/mono").accept(new CharSequence[]{"text/plain"}), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)ASSERTION));
    }

    @Test
    void txtBooleanFlux() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/txt/boolean/flux").accept(new CharSequence[]{"text/plain"}), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)ASSERTION));
    }

    @Controller(value="/txt")
    @Requires(property="spec.name", value="TxtPlainBooleanTest")
    static class OnErrorMethodController {
        OnErrorMethodController() {
        }

        @Get(value="/boolean")
        @Produces(value={"text/plain"})
        Boolean index() {
            return Boolean.TRUE;
        }

        @Get(value="/boolean/mono")
        @Produces(value={"text/plain"})
        @SingleResult
        Publisher<Boolean> mono() {
            return Mono.just((Object)Boolean.TRUE);
        }

        @Get(value="/boolean/flux")
        @Produces(value={"text/plain"})
        @SingleResult
        Publisher<Boolean> flux() {
            return Flux.just((Object)Boolean.TRUE);
        }
    }
}

