/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.forms;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormsJacksonAnnotationsTest {
    private static final String SPEC_NAME = "FormsJacksonAnnotationsTest";
    private static final String JSON_WITH_PAGES = "{\"title\":\"Building Microservices\",\"paginas\":100}";
    private static final String JSON_WITHOUT_PAGES = "{\"title\":\"Building Microservices\"}";

    @Test
    public void serverFormSubmissionsSupportJacksonAnnotations() throws IOException {
        String body = "title=Building+Microservices&paginas=100";
        FormsJacksonAnnotationsTest.assertWithBody(body, JSON_WITH_PAGES);
        body = "title=Building+Microservices&pages=";
        FormsJacksonAnnotationsTest.assertWithBody(body, JSON_WITHOUT_PAGES);
    }

    @Test
    public void httpClientFormSubmissionsDoesNotSupportJacksonAnnotations() throws IOException {
        Book book = new Book("Building Microservices", 100);
        FormsJacksonAnnotationsTest.assertWithBody(book, JSON_WITHOUT_PAGES);
    }

    private static void assertWithBody(Object body, String expectedJson) throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.POST((String)"/book/save", (Object)body).contentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(httpResponse -> {
            Optional bodyOptional = httpResponse.getBody(String.class);
            Assertions.assertTrue((boolean)bodyOptional.isPresent());
            Assertions.assertEquals((Object)expectedJson, bodyOptional.get());
        }).build())).run();
    }

    @Introspected
    record Book(@JsonProperty(value="title") @NonNull String title, @JsonProperty(value="paginas") @Nullable Integer pages) {
    }

    @Requires(property="spec.name", value="FormsJacksonAnnotationsTest")
    @Controller(value="/book")
    static class SaveController {
        SaveController() {
        }

        @Consumes(value={"application/x-www-form-urlencoded"})
        @Post(value="/save")
        Book save(@Body Book book) {
            return book;
        }
    }
}

