/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.forms;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormsInputNumberOptionalTest {
    private static final String SPEC_NAME = "FormsInputNumberOptionalTest";

    @Test
    public void formSubmissionOptionalInputTypeNumber() throws IOException {
        String body = "title=Building+Microservices&pages=100";
        String expectedJson = "{\"title\":\"Building Microservices\",\"pages\":100}";
        FormsInputNumberOptionalTest.assertWithBody(body, expectedJson);
        body = "title=Building+Microservices&pages=";
        expectedJson = "{\"title\":\"Building Microservices\"}";
        FormsInputNumberOptionalTest.assertWithBody(body, expectedJson);
    }

    private static void assertWithBody(String body, String expectedJson) throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.POST((String)"/book/save", (Object)body).contentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(httpResponse -> {
            Optional bodyOptional = httpResponse.getBody(String.class);
            Assertions.assertTrue((boolean)bodyOptional.isPresent());
            Assertions.assertEquals((Object)expectedJson, bodyOptional.get());
        }).build())).run();
    }

    @Introspected
    record Book(@NonNull String title, @Nullable Integer pages) {
    }

    @Requires(property="spec.name", value="FormsInputNumberOptionalTest")
    @Controller(value="/book")
    static class SaveController {
        SaveController() {
        }

        @Consumes(value={"application/x-www-form-urlencoded"})
        @Post(value="/save")
        Book save(@Body Book book) {
            return book;
        }
    }
}

