/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.filter;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.junit.jupiter.api.Test;

public class RequestFilterCompletionStageFutureProceedTest {
    public static final String SPEC_NAME = "RequestFilterCompletionStageFutureProceedTest";

    @Test
    public void requestFilterProceedWithCompletableFuture() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/foobar").header((CharSequence)"X-FOOBAR", (CharSequence)"123")).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.ACCEPTED).build())).run();
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/foobar")).assertion((server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.UNAUTHORIZED).build())).run();
    }

    @Requires(property="spec.name", value="RequestFilterCompletionStageFutureProceedTest")
    @Controller(value="/foobar")
    static class FooBarController {
        FooBarController() {
        }

        @Get
        @Status(value=HttpStatus.ACCEPTED)
        void index() {
        }
    }

    @Requires(property="spec.name", value="RequestFilterCompletionStageFutureProceedTest")
    @ServerFilter(value={"/**"})
    static class FooBarFilter {
        FooBarFilter() {
        }

        @RequestFilter
        CompletionStage<@Nullable HttpResponse<?>> filter(@NonNull HttpRequest<?> request) {
            if (request.getHeaders().contains("X-FOOBAR")) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.completedFuture(HttpResponse.unauthorized());
        }
    }
}

