/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class StreamTest {
    public static final String SPEC_NAME = "StreamTest";

    @Test
    void statusErrorAsFirstItem() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/stream/status-error-as-first-item").header((CharSequence)"Content-Type", (CharSequence)"text/plain"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NOT_FOUND).body("foo").build()));
    }

    @Test
    void statusErrorImmediate() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/stream/status-error-immediate").header((CharSequence)"Content-Type", (CharSequence)"text/plain"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.NOT_FOUND).body("foo").build()));
    }

    @Controller(value="/stream")
    @Requires(property="spec.name", value="StreamTest")
    static class StreamController {
        StreamController() {
        }

        @Get(uri="/status-error-as-first-item", processes={"text/plain"})
        Publisher<String> statusErrorAsFirstItem() {
            return Flux.error((Throwable)new HttpStatusException(HttpStatus.NOT_FOUND, (Object)"foo"));
        }

        @Get(uri="/status-error-immediate", processes={"text/plain"})
        Publisher<String> statusErrorImmediate() {
            throw new HttpStatusException(HttpStatus.NOT_FOUND, (Object)"foo");
        }
    }
}

