/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class BodyTest {
    public static final String SPEC_NAME = "BodyTest";

    @Test
    void testCustomBodyPOJO() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-body/pojo", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body("{\"x\":10,\"y\":20}").build()));
    }

    @Test
    void testCustomBodyPOJOAsPart() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-body/part-pojo", (Object)"{\"point\":{\"x\":10,\"y\":20},\"foo\":\"bar\"}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body("{\"x\":10,\"y\":20}").build()));
    }

    @Test
    void testCustomBodyPOJODefaultToJSON() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-body/pojo", (Object)"{\"x\":10,\"y\":20}"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body("{\"x\":10,\"y\":20}").build()));
    }

    @Test
    void testCustomBodyPOJOWithWholeRequest() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-body/pojo-and-request", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> HttpResponseAssertion.builder().status(HttpStatus.CREATED).body("{\"x\":10,\"y\":20}").build());
    }

    @Test
    void testCustomBodyPOJOReactiveTypes() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-body/pojo-reactive", (Object)"{\"x\":10,\"y\":20}").header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body("{\"x\":10,\"y\":20}").build()));
    }

    @Test
    void testCustomListBodyPOJOReactiveTypes() throws IOException {
        String body = "[{\"x\":10,\"y\":20},{\"x\":30,\"y\":40}]";
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-body/pojo-flux", (Object)body).header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body(BodyAssertion.builder().body(body).equals()).build()));
    }

    @Test
    void testRequestBodyJsonNoBodyAnnotation() throws IOException {
        String body = "{\"x\":10,\"y\":20}";
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-body/args-no-body", (Object)body).header((CharSequence)"Content-Type", (CharSequence)"application/json"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body(BodyAssertion.builder().body(body).equals()).build()));
    }

    @Test
    void testRequestBodyFormDataNoBodyAnnotation() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.POST((String)"/response-body/args-no-body-form", (Object)"x=10&y=20").header((CharSequence)"Content-Type", (CharSequence)"application/x-www-form-urlencoded"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body(BodyAssertion.builder().body("{\"x\":10,\"y\":20}").equals()).build()));
    }

    @Test
    void testEmptyFuture() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-body/empty-future").header((CharSequence)"Content-Type", (CharSequence)"application/x-www-form-urlencoded"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).build()));
    }

    @Test
    void testEmptySingleResultPublisher() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/response-body/empty-single-result").header((CharSequence)"Content-Type", (CharSequence)"application/x-www-form-urlencoded"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).build()));
    }

    @Test
    void testRedirectFuture() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.GET((String)"/response-body/redirect-future")).configuration(Map.of("micronaut.http.client.follow-redirects", false)).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.FOUND).header("Location", "https://example.com").build())).run();
    }

    @Test
    void testObjectBody() throws IOException {
        TestScenario.builder().specName(SPEC_NAME).request((HttpRequest)HttpRequest.POST((String)"/response-body/object", Map.of("fizz", "buzz"))).assertion((server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.CREATED).body("obj: {fizz=buzz}").build())).run();
    }

    @Introspected
    static class Point {
        private Integer x;
        private Integer y;

        public Point(Integer x, Integer y) {
            this.x = x;
            this.y = y;
        }

        public Integer getX() {
            return this.x;
        }

        public void setX(Integer x) {
            this.x = x;
        }

        public Integer getY() {
            return this.y;
        }

        public void setY(Integer y) {
            this.y = y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Point point = (Point)o;
            if (!Objects.equals(this.x, point.x)) {
                return false;
            }
            return Objects.equals(this.y, point.y);
        }

        public int hashCode() {
            int result = this.x != null ? this.x.hashCode() : 0;
            result = 31 * result + (this.y != null ? this.y.hashCode() : 0);
            return result;
        }
    }

    @Controller(value="/response-body")
    @Requires(property="spec.name", value="BodyTest")
    static class BodyController {
        BodyController() {
        }

        @Post(uri="/pojo")
        @Status(value=HttpStatus.CREATED)
        Point post(@Body Point data) {
            return data;
        }

        @Post(uri="/args-no-body")
        @Status(value=HttpStatus.CREATED)
        Point postNoBody(Integer x, Integer y) {
            return new Point(x, y);
        }

        @Consumes(value={"application/x-www-form-urlencoded"})
        @Post(value="/args-no-body-form")
        @Status(value=HttpStatus.CREATED)
        Point postNoBodyFormData(Integer x, Integer y) {
            return new Point(x, y);
        }

        @Post(uri="/part-pojo")
        @Status(value=HttpStatus.CREATED)
        Point postPart(@Body(value="point") Point data) {
            return data;
        }

        @Post(uri="/pojo-and-request")
        @Status(value=HttpStatus.CREATED)
        Point postRequest(HttpRequest<Point> request) {
            return request.getBody().orElse(null);
        }

        @Post(uri="/pojo-reactive")
        @Status(value=HttpStatus.CREATED)
        @SingleResult
        Publisher<Point> post(@Body Publisher<Point> data) {
            return data;
        }

        @Post(uri="/pojo-flux")
        @Status(value=HttpStatus.CREATED)
        Publisher<Point> postMany(@Body Publisher<Point> data) {
            return data;
        }

        @Post(uri="/bytes", consumes={"text/plain"})
        @Status(value=HttpStatus.CREATED)
        String postBytes(@Body byte[] bytes) {
            return new String(bytes);
        }

        @Get(uri="/empty-future")
        CompletableFuture<HttpResponse<?>> emptyFuture() {
            return CompletableFuture.completedFuture(HttpResponse.ok());
        }

        @Get(uri="/empty-single-result")
        @SingleResult
        Publisher<HttpResponse<?>> emptySingleResult() {
            return Mono.just((Object)HttpResponse.ok());
        }

        @Get(uri="/redirect-future")
        CompletableFuture<HttpResponse<?>> redirectFuture() {
            return CompletableFuture.completedFuture(HttpResponse.status((HttpStatus)HttpStatus.FOUND).header((CharSequence)"Location", (CharSequence)"https://example.com"));
        }

        @Post(uri="/object", consumes={"text/plain"})
        @Status(value=HttpStatus.CREATED)
        @Consumes(value={"application/json"})
        String objectBody(@Body Object obj) {
            return "obj: " + String.valueOf(obj);
        }
    }
}

