/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.routing;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import io.micronaut.scheduling.annotation.ExecuteOn;
import java.io.IOException;
import java.util.List;
import org.junit.jupiter.api.Test;

public class RootRoutingTest {
    public static final String SPEC_NAME = "RootRoutingTest";

    @Test
    void testRouting() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("{\"key\":\"hello\",\"value\":\"world\"}").equals()).build()));
    }

    @Introspected
    private record KeyValue(String key, String value) {
    }

    @Requires(property="spec.name", value="RootRoutingTest")
    @Controller
    @ExecuteOn(value="blocking")
    static class MyController {
        MyController() {
        }

        @Post
        public KeyValue createRoot(@Body KeyValue body) {
            return body;
        }

        @Get
        public KeyValue root() {
            return new KeyValue("hello", "world");
        }

        @Get(value="/{id}")
        public KeyValue id(String id) {
            return new KeyValue("hello", id);
        }

        @Get(value="/{id}/items")
        public List<KeyValue> items(String id) {
            return List.of(new KeyValue("hello", id), new KeyValue("foo", "bar"));
        }
    }
}

