/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.tck.tests.mediatype;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringDefaultMediaTypeTest {
    public static final String SPEC_NAME = "StringDefaultMediaTypeTest";
    private static final HttpResponseAssertion ASSERTION = HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("Hello World").equals()).assertResponse(response -> {
        Assertions.assertTrue((boolean)response.getContentType().isPresent());
        Assertions.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, response.getContentType().get());
    }).build();

    @Test
    void jsonIsDefaultMediaTypeForString() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/str"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)ASSERTION));
    }

    @Controller(value="/str")
    @Requires(property="spec.name", value="StringDefaultMediaTypeTest")
    static class StrDefaultEncoding {
        StrDefaultEncoding() {
        }

        @Get
        String index() {
            return "Hello World";
        }
    }
}

